/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.alerts;

import org.apache.helix.HelixException;
import org.apache.helix.alerts.Aggregator;
import org.apache.helix.alerts.Tuple;

public class AccumulateAggregator
extends Aggregator {
    public AccumulateAggregator() {
        this._numArgs = 0;
    }

    @Override
    public void merge(Tuple<String> currValTup, Tuple<String> newValTup, Tuple<String> currTimeTup, Tuple<String> newTimeTup, String ... args) {
        double mergedTime;
        double mergedVal;
        double currVal = 0.0;
        double currTime = -1.0;
        if (currValTup == null || newValTup == null || currTimeTup == null || newTimeTup == null) {
            throw new HelixException("Tuples cannot be null");
        }
        if (currValTup.size() > 0 && currTimeTup.size() > 0) {
            currVal = Double.parseDouble(currValTup.iterator().next());
            currTime = Double.parseDouble(currTimeTup.iterator().next());
        }
        double newVal = Double.parseDouble(newValTup.iterator().next());
        double newTime = Double.parseDouble(newTimeTup.iterator().next());
        if (newTime > currTime) {
            mergedVal = currVal + newVal;
            mergedTime = newTime;
        } else {
            mergedVal = currVal;
            mergedTime = currTime;
        }
        currValTup.clear();
        currValTup.add(Double.toString(mergedVal));
        currTimeTup.clear();
        currTimeTup.add(Double.toString(mergedTime));
    }
}

