/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.util.LogEntry;
import org.uberfire.backend.util.MessageList;

public class LoggingHelper {
    private final Logger log;
    private static final MessageList messages = new MessageList();

    public static LogEntry[] getMessages() {
        return messages.getMessages();
    }

    public static void cleanLog() {
        messages.cleanEntry();
    }

    public static LoggingHelper getLogger(Class<?> cls) {
        return new LoggingHelper(cls);
    }

    private LoggingHelper(Class<?> cls) {
        this.log = LoggerFactory.getLogger(cls);
    }

    public void info(String message) {
        this.log.info(message);
        messages.add(message, 1);
    }

    public void info(String message, Throwable error) {
        this.log.info(message, error);
        messages.add(message + " " + error.getMessage(), 1);
    }

    public void debug(String message) {
        this.log.debug(message);
    }

    public void error(String message) {
        this.log.error(message);
        messages.add(message, 0);
    }

    public void error(String message, Throwable error) {
        this.log.error(message, error);
        messages.add(message + " " + error.getMessage(), 0);
    }

    public void warn(String message) {
        this.log.warn(message);
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }
}

