/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.bind.JAXBException;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelException;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.view.ModelFileGenerator;
import org.apache.camel.view.RouteDotGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MainSupport
extends ServiceSupport {
    protected static final Log LOG = LogFactory.getLog(MainSupport.class);
    protected String dotOutputDir;
    protected final List<Option> options = new ArrayList<Option>();
    protected final CountDownLatch latch = new CountDownLatch(1);
    protected final AtomicBoolean completed = new AtomicBoolean(false);
    protected long duration = -1L;
    protected TimeUnit timeUnit = TimeUnit.MILLISECONDS;
    protected String routesOutputFile;
    protected boolean aggregateDot;
    protected boolean trace;
    protected List<RouteBuilder> routeBuilders = new ArrayList<RouteBuilder>();
    protected final List<CamelContext> camelContexts = new ArrayList<CamelContext>();
    protected ProducerTemplate camelTemplate;

    protected MainSupport() {
        this.addOption(new Option("h", "help", "Displays the help screen"){

            @Override
            protected void doProcess(String arg, LinkedList<String> remainingArgs) {
                MainSupport.this.showOptions();
                MainSupport.this.completed();
            }
        });
        this.addOption(new ParameterOption("o", "outdir", "Sets the DOT output directory where the visual representations of the routes are generated", "dot"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                MainSupport.this.setDotOutputDir(parameter);
            }
        });
        this.addOption(new ParameterOption("ad", "aggregate-dot", "Aggregates all routes (in addition to individual route generation) into one context to create one monolithic DOT file for visual representations the entire system.", "aggregate-dot"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                MainSupport.this.setAggregateDot("true".equals(parameter));
            }
        });
        this.addOption(new ParameterOption("d", "duration", "Sets the time duration that the application will run for, by default in milliseconds. You can use '10s' for 10 seconds etc", "duration"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                String value = parameter.toUpperCase();
                if (value.endsWith("S")) {
                    value = value.substring(0, value.length() - 1);
                    MainSupport.this.setTimeUnit(TimeUnit.SECONDS);
                }
                MainSupport.this.setDuration(Integer.parseInt(value));
            }
        });
        this.addOption(new Option("t", "trace", "Enables tracing"){

            @Override
            protected void doProcess(String arg, LinkedList<String> remainingArgs) {
                MainSupport.this.enableTrace();
            }
        });
        this.addOption(new ParameterOption("out", "output", "Output all routes to the specified XML file", "filename"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                MainSupport.this.setRoutesOutputFile(parameter);
            }
        });
    }

    public void run() throws Exception {
        if (!this.completed.get()) {
            this.start();
            try {
                this.afterStart();
                this.waitUntilCompleted();
                this.beforeStop();
                this.stop();
            }
            catch (Exception e) {
                LOG.error((Object)("Failed: " + e), (Throwable)e);
            }
        }
    }

    protected void afterStart() {
    }

    protected void beforeStop() {
    }

    public void completed() {
        this.completed.set(true);
        this.latch.countDown();
    }

    public void showOptions() {
        this.showOptionsHeader();
        for (Option option : this.options) {
            System.out.println(option.getInformation());
        }
    }

    public void parseArguments(String[] arguments) {
        LinkedList<String> args = new LinkedList<String>(Arrays.asList(arguments));
        boolean valid = true;
        while (!args.isEmpty()) {
            String arg = args.removeFirst();
            boolean handled = false;
            for (Option option : this.options) {
                if (!option.processOption(arg, args)) continue;
                handled = true;
                break;
            }
            if (handled) continue;
            System.out.println("Unknown option: " + arg);
            System.out.println();
            valid = false;
            break;
        }
        if (!valid) {
            this.showOptions();
            this.completed();
        }
    }

    public void addOption(Option option) {
        this.options.add(option);
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public String getDotOutputDir() {
        return this.dotOutputDir;
    }

    public void setDotOutputDir(String dotOutputDir) {
        this.dotOutputDir = dotOutputDir;
    }

    public void setAggregateDot(boolean aggregateDot) {
        this.aggregateDot = aggregateDot;
    }

    public boolean isAggregateDot() {
        return this.aggregateDot;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void enableTrace() {
        this.trace = true;
        for (CamelContext context : this.camelContexts) {
            context.setTracing(true);
        }
    }

    public void setRoutesOutputFile(String routesOutputFile) {
        this.routesOutputFile = routesOutputFile;
    }

    public String getRoutesOutputFile() {
        return this.routesOutputFile;
    }

    @Override
    protected void doStop() throws Exception {
        LOG.info((Object)("Apache Camel " + this.getVersion() + " stopping"));
        this.completed();
    }

    @Override
    protected void doStart() throws Exception {
        LOG.info((Object)("Apache Camel " + this.getVersion() + " starting"));
    }

    protected void waitUntilCompleted() {
        while (!this.completed.get()) {
            try {
                if (this.duration > 0L) {
                    TimeUnit unit = this.getTimeUnit();
                    LOG.info((Object)("Waiting for: " + this.duration + " " + (Object)((Object)unit)));
                    this.latch.await(this.duration, unit);
                    this.completed.set(true);
                    continue;
                }
                this.latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void run(String[] args) throws Exception {
        this.parseArguments(args);
        this.run();
    }

    public void showOptionsHeader() {
        System.out.println("Apache Camel Runner takes the following options");
        System.out.println();
    }

    public List<CamelContext> getCamelContexts() {
        return this.camelContexts;
    }

    public List<RouteBuilder> getRouteBuilders() {
        return this.routeBuilders;
    }

    public void setRouteBuilders(List<RouteBuilder> routeBuilders) {
        this.routeBuilders = routeBuilders;
    }

    public List<RouteDefinition> getRouteDefinitions() {
        ArrayList<RouteDefinition> answer = new ArrayList<RouteDefinition>();
        for (CamelContext camelContext : this.camelContexts) {
            answer.addAll(camelContext.getRouteDefinitions());
        }
        return answer;
    }

    public ProducerTemplate getCamelTemplate() throws Exception {
        if (this.camelTemplate == null) {
            this.camelTemplate = this.findOrCreateCamelTemplate();
        }
        return this.camelTemplate;
    }

    protected abstract ProducerTemplate findOrCreateCamelTemplate();

    protected abstract Map<String, CamelContext> getCamelContextMap();

    protected void postProcessContext() throws Exception {
        Map<String, CamelContext> map = this.getCamelContextMap();
        if (map.size() == 0) {
            throw new CamelException("Cannot find any Camel Context from the Application Context. Please check your Application Context setting");
        }
        Set<Map.Entry<String, CamelContext>> entries = map.entrySet();
        int size = entries.size();
        for (Map.Entry<String, CamelContext> entry : entries) {
            String name = entry.getKey();
            CamelContext camelContext = entry.getValue();
            this.camelContexts.add(camelContext);
            this.generateDot(name, camelContext, size);
            this.postProcessCamelContext(camelContext);
        }
        if (this.isAggregateDot()) {
            this.generateDot("aggregate", this.aggregateCamelContext(), 1);
        }
        if (!"".equals(this.getRoutesOutputFile())) {
            this.outputRoutesToFile();
        }
    }

    protected void outputRoutesToFile() throws IOException, JAXBException {
        if (ObjectHelper.isNotEmpty(this.getRoutesOutputFile())) {
            LOG.info((Object)("Generating routes as XML in the file named: " + this.getRoutesOutputFile()));
            ModelFileGenerator generator = this.createModelFileGenerator();
            generator.marshalRoutesUsingJaxb(this.getRoutesOutputFile(), this.getRouteDefinitions());
        }
    }

    protected abstract ModelFileGenerator createModelFileGenerator() throws JAXBException;

    protected void generateDot(String name, CamelContext camelContext, int size) throws IOException {
        String outputDir = this.dotOutputDir;
        if (ObjectHelper.isNotEmpty(outputDir)) {
            if (size > 1) {
                outputDir = outputDir + "/" + name;
            }
            RouteDotGenerator generator = new RouteDotGenerator(outputDir);
            LOG.info((Object)("Generating DOT file for routes: " + outputDir + " for: " + camelContext + " with name: " + name));
            generator.drawRoutes(camelContext);
        }
    }

    private CamelContext aggregateCamelContext() throws Exception {
        if (this.camelContexts.size() == 1) {
            return this.camelContexts.get(0);
        }
        DefaultCamelContext answer = new DefaultCamelContext();
        for (CamelContext camelContext : this.camelContexts) {
            answer.addRouteDefinitions(camelContext.getRouteDefinitions());
        }
        return answer;
    }

    protected void postProcessCamelContext(CamelContext camelContext) throws Exception {
        for (RouteBuilder routeBuilder : this.routeBuilders) {
            camelContext.addRoutes(routeBuilder);
        }
    }

    public void addRouteBuilder(RouteBuilder routeBuilder) {
        this.getRouteBuilders().add(routeBuilder);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class ParameterOption
    extends Option {
        private String parameterName;

        protected ParameterOption(String abbreviation, String fullName, String description, String parameterName) {
            super(abbreviation, fullName, description);
            this.parameterName = parameterName;
        }

        @Override
        protected void doProcess(String arg, LinkedList<String> remainingArgs) {
            if (remainingArgs.isEmpty()) {
                System.err.println("Expected fileName for ");
                MainSupport.this.showOptions();
                MainSupport.this.completed();
            } else {
                String parameter = remainingArgs.removeFirst();
                this.doProcess(arg, parameter, remainingArgs);
            }
        }

        @Override
        public String getInformation() {
            return "  " + this.getAbbreviation() + " or " + this.getFullName() + " <" + this.parameterName + "> = " + this.getDescription();
        }

        protected abstract void doProcess(String var1, String var2, LinkedList<String> var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class Option {
        private String abbreviation;
        private String fullName;
        private String description;

        protected Option(String abbreviation, String fullName, String description) {
            this.abbreviation = "-" + abbreviation;
            this.fullName = "-" + fullName;
            this.description = description;
        }

        public boolean processOption(String arg, LinkedList<String> remainingArgs) {
            if (arg.equalsIgnoreCase(this.abbreviation) || this.fullName.startsWith(arg)) {
                this.doProcess(arg, remainingArgs);
                return true;
            }
            return false;
        }

        public String getAbbreviation() {
            return this.abbreviation;
        }

        public String getDescription() {
            return this.description;
        }

        public String getFullName() {
            return this.fullName;
        }

        public String getInformation() {
            return "  " + this.getAbbreviation() + " or " + this.getFullName() + " = " + this.getDescription();
        }

        protected abstract void doProcess(String var1, LinkedList<String> var2);
    }
}

