/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=21.0
//  number=$Revision: 6546 $
//  type=root
//  date=$Date: 2012-02-07 13:32:35 -0500 (Tue, 07 Feb 2012) $


/**
 * Localized names for the "ln" locale.
 */
public class LocalizedNamesImpl_ln extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AF",
        "ZA",
        "SA",
        "DE",
        "AL",
        "DZ",
        "US",
        "AM",
        "AD",
        "AI",
        "AO",
        "GB",
        "AG",
        "AN",
        "AQ",
        "AR",
        "AW",
        "AX",
        "HT",
        "AZ",
        "BS",
        "BH",
        "BB",
        "BE",
        "BZ",
        "BD",
        "BJ",
        "BM",
        "BG",
        "CV",
        "KY",
        "CK",
        "FK",
        "MP",
        "MH",
        "TC",
        "VI",
        "VG",
        "SB",
        "BL",
        "BO",
        "BA",
        "BW",
        "BQ",
        "BR",
        "BN",
        "BF",
        "BI",
        "BT",
        "BV",
        "BY",
        "CC",
        "CP",
        "CW",
        "CX",
        "DK",
        "DG",
        "DM",
        "DJ",
        "EA",
        "EH",
        "EC",
        "ER",
        "NF",
        "ES",
        "EE",
        "ET",
        "EU",
        "EG",
        "FR",
        "FJ",
        "FI",
        "PH",
        "FO",
        "GA",
        "GM",
        "GH",
        "GR",
        "GD",
        "GG",
        "GN",
        "GW",
        "GQ",
        "GY",
        "GF",
        "GL",
        "GS",
        "GP",
        "GU",
        "GT",
        "HK",
        "HM",
        "IC",
        "UA",
        "IM",
        "ID",
        "IN",
        "IR",
        "IQ",
        "IE",
        "UY",
        "IS",
        "IL",
        "IT",
        "JE",
        "NC",
        "KH",
        "CM",
        "CA",
        "QA",
        "KZ",
        "KE",
        "CU",
        "KG",
        "KI",
        "CO",
        "KM",
        "CG",
        "KP",
        "KR",
        "CR",
        "CI",
        "KW",
        "HR",
        "LA",
        "RE",
        "LS",
        "LV",
        "LB",
        "LR",
        "LY",
        "LU",
        "LI",
        "LT",
        "AE",
        "IO",
        "MG",
        "MV",
        "MW",
        "MY",
        "ML",
        "MT",
        "MA",
        "MQ",
        "MK",
        "YT",
        "ME",
        "MX",
        "MF",
        "FM",
        "MM",
        "MO",
        "MD",
        "MC",
        "MN",
        "MU",
        "MR",
        "MZ",
        "MS",
        "NA",
        "NR",
        "NP",
        "NI",
        "NG",
        "NE",
        "NO",
        "NU",
        "NL",
        "OM",
        "HN",
        "HU",
        "AU",
        "AT",
        "PK",
        "PY",
        "PW",
        "PS",
        "PA",
        "PG",
        "PE",
        "PN",
        "PF",
        "PL",
        "PT",
        "PR",
        "QO",
        "CD",
        "CZ",
        "CF",
        "DO",
        "RU",
        "RO",
        "RS",
        "RW",
        "WS",
        "AS",
        "SH",
        "KN",
        "LC",
        "SM",
        "PM",
        "VC",
        "ST",
        "SV",
        "SN",
        "CS",
        "SL",
        "CL",
        "SK",
        "SI",
        "SG",
        "CN",
        "CY",
        "SY",
        "LK",
        "SJ",
        "SO",
        "SS",
        "SD",
        "SR",
        "SZ",
        "SE",
        "CH",
        "SX",
        "SC",
        "TA",
        "TH",
        "TW",
        "TZ",
        "TJ",
        "TF",
        "TM",
        "TR",
        "TL",
        "TT",
        "TN",
        "TG",
        "TK",
        "TO",
        "TD",
        "TV",
        "UG",
        "UM",
        "UZ",
        "VU",
        "VA",
        "VE",
        "VN",
        "WF",
        "YE",
        "JM",
        "ZM",
        "JP",
        "NZ",
        "GI",
        "ZW",
        "GE",
        "JO",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AD", "Andorɛ");
    namesMap.put("AE", "Lɛmila alabo");
    namesMap.put("AF", "Afiganisitá");
    namesMap.put("AG", "Antiga mpé Barbuda");
    namesMap.put("AI", "Angiyɛ");
    namesMap.put("AL", "Alibani");
    namesMap.put("AM", "Amɛni");
    namesMap.put("AN", "Antiyɛ ya Olandɛ");
    namesMap.put("AO", "Angóla");
    namesMap.put("AR", "Arizantinɛ");
    namesMap.put("AS", "Samoa ya Ameriki");
    namesMap.put("AT", "Otilisi");
    namesMap.put("AU", "Ositáli");
    namesMap.put("AZ", "Azɛlɛbaizá");
    namesMap.put("BA", "Bosini mpé Hezegovine");
    namesMap.put("BB", "Barɛbadɛ");
    namesMap.put("BD", "Bengalidɛsi");
    namesMap.put("BE", "Beleziki");
    namesMap.put("BF", "Bukina Faso");
    namesMap.put("BG", "Biligari");
    namesMap.put("BH", "Bahrɛnɛ");
    namesMap.put("BJ", "Benɛ");
    namesMap.put("BN", "Brineyi");
    namesMap.put("BO", "Bolivi");
    namesMap.put("BR", "Brezílɛ");
    namesMap.put("BS", "Bahamasɛ");
    namesMap.put("BT", "Butáni");
    namesMap.put("BY", "Byelorisi");
    namesMap.put("BZ", "Belizɛ");
    namesMap.put("CA", "Kanada");
    namesMap.put("CD", "Repibiki demokratiki ya Kongó");
    namesMap.put("CF", "Repibiki ya Afríka ya Káti");
    namesMap.put("CG", "Kongo");
    namesMap.put("CH", "Swisɛ");
    namesMap.put("CI", "Kotídivualɛ");
    namesMap.put("CK", "Bisanga bya Kookɛ");
    namesMap.put("CL", "Síli");
    namesMap.put("CM", "Kamɛrune");
    namesMap.put("CN", "Sinɛ");
    namesMap.put("CO", "Kolombi");
    namesMap.put("CR", "Kositarika");
    namesMap.put("CS", "Serebi mpé Monténegro");
    namesMap.put("CU", "Kiba");
    namesMap.put("CV", "Bisanga bya Kapevɛrɛ");
    namesMap.put("CY", "Sípɛlɛ");
    namesMap.put("CZ", "Repibiki Tsekɛ");
    namesMap.put("DE", "Alemani");
    namesMap.put("DJ", "Dzibuti");
    namesMap.put("DK", "Danɛmarike");
    namesMap.put("DM", "Domínike");
    namesMap.put("DO", "Repibiki ya Domínikɛ");
    namesMap.put("DZ", "Alizɛri");
    namesMap.put("EC", "Ekwatɛ́lɛ");
    namesMap.put("EE", "Esitoni");
    namesMap.put("EG", "Ezípite");
    namesMap.put("ER", "Elitelɛ");
    namesMap.put("ES", "Esipanye");
    namesMap.put("ET", "Etsíopi");
    namesMap.put("FI", "Filandɛ");
    namesMap.put("FJ", "Fidzi");
    namesMap.put("FK", "Bisanga bya Maluni");
    namesMap.put("FM", "Mikronezi");
    namesMap.put("FR", "Falánsɛ");
    namesMap.put("GA", "Gabɔ");
    namesMap.put("GB", "Angɛlɛtɛ́lɛ");
    namesMap.put("GD", "Gelenadɛ");
    namesMap.put("GE", "Zorzi");
    namesMap.put("GF", "Giyanɛ ya Falánsɛ");
    namesMap.put("GH", "Gana");
    namesMap.put("GI", "Zibatalɛ");
    namesMap.put("GL", "Gowelande");
    namesMap.put("GM", "Gambi");
    namesMap.put("GN", "Ginɛ");
    namesMap.put("GP", "Gwadɛlupɛ");
    namesMap.put("GQ", "Ginɛ́kwatɛ́lɛ");
    namesMap.put("GR", "Geleki");
    namesMap.put("GT", "Gwatémala");
    namesMap.put("GU", "Gwamɛ");
    namesMap.put("GW", "Ginɛbisau");
    namesMap.put("GY", "Giyane");
    namesMap.put("HN", "Ondurasɛ");
    namesMap.put("HR", "Krowasi");
    namesMap.put("HT", "Ayiti");
    namesMap.put("HU", "Ongili");
    namesMap.put("ID", "Indonezi");
    namesMap.put("IE", "Irelandɛ");
    namesMap.put("IL", "Isirayelɛ");
    namesMap.put("IN", "Índɛ");
    namesMap.put("IO", "Mabelé ya Angɛlɛtɛ́lɛ na mbú ya Indiya");
    namesMap.put("IQ", "Iraki");
    namesMap.put("IR", "Irâ");
    namesMap.put("IS", "Isilandɛ");
    namesMap.put("IT", "Itali");
    namesMap.put("JM", "Zamaiki");
    namesMap.put("JO", "Zɔdani");
    namesMap.put("JP", "Zapɔ");
    namesMap.put("KG", "Kigizisitá");
    namesMap.put("KH", "Kambodza");
    namesMap.put("KM", "Komorɛ");
    namesMap.put("KN", "Sántu krístofe mpé Nevɛ̀s");
    namesMap.put("KP", "Korɛ ya nɔ́rdi");
    namesMap.put("KR", "Korɛ ya súdi");
    namesMap.put("KW", "Koweti");
    namesMap.put("KY", "Bisanga bya Kayíma");
    namesMap.put("KZ", "Kazakisitá");
    namesMap.put("LA", "Lawosi");
    namesMap.put("LB", "Libá");
    namesMap.put("LC", "Sántu lisi");
    namesMap.put("LI", "Lishɛteni");
    namesMap.put("LK", "Sirilanka");
    namesMap.put("LR", "Libériya");
    namesMap.put("LS", "Lesoto");
    namesMap.put("LT", "Litwani");
    namesMap.put("LU", "Likisambulu");
    namesMap.put("LV", "Letoni");
    namesMap.put("LY", "Libí");
    namesMap.put("MA", "Marokɛ");
    namesMap.put("MC", "Monako");
    namesMap.put("MD", "Molidavi");
    namesMap.put("MG", "Madagasikari");
    namesMap.put("MH", "Bisanga bya Marishalɛ");
    namesMap.put("MK", "Masedwanɛ");
    namesMap.put("ML", "Malí");
    namesMap.put("MN", "Mongolí");
    namesMap.put("MP", "Bisanga bya Marianɛ ya nɔ́rdi");
    namesMap.put("MQ", "Martiniki");
    namesMap.put("MR", "Moritani");
    namesMap.put("MS", "Mɔsera");
    namesMap.put("MT", "Malitɛ");
    namesMap.put("MU", "Morisɛ");
    namesMap.put("MV", "Madívɛ");
    namesMap.put("MX", "Meksike");
    namesMap.put("MY", "Malezi");
    namesMap.put("MZ", "Mozambíki");
    namesMap.put("NA", "Namibi");
    namesMap.put("NC", "Kaledoni ya sika");
    namesMap.put("NE", "Nizɛrɛ");
    namesMap.put("NF", "Esanga Norfokɛ");
    namesMap.put("NG", "Nizerya");
    namesMap.put("NI", "Nikaragwa");
    namesMap.put("NL", "Olandɛ");
    namesMap.put("NO", "Norivezɛ");
    namesMap.put("NP", "Nepálɛ");
    namesMap.put("NU", "Nyué");
    namesMap.put("NZ", "Zelandɛ ya sika");
    namesMap.put("OM", "Ománɛ");
    namesMap.put("PE", "Péru");
    namesMap.put("PF", "Polinezi ya Falánsɛ");
    namesMap.put("PG", "Papwazi Ginɛ ya sika");
    namesMap.put("PH", "Filipinɛ");
    namesMap.put("PK", "Pakisitá");
    namesMap.put("PL", "Poloni");
    namesMap.put("PM", "Sántu pététo mpé Mikelɔ");
    namesMap.put("PN", "Pikairni");
    namesMap.put("PR", "Pɔtoriko");
    namesMap.put("PS", "Palɛsine");
    namesMap.put("PT", "Putúlugɛsi");
    namesMap.put("PY", "Palagwei");
    namesMap.put("QA", "Katari");
    namesMap.put("RE", "Lenyo");
    namesMap.put("RO", "Romani");
    namesMap.put("RU", "Risí");
    namesMap.put("SA", "Alabi Sawuditɛ");
    namesMap.put("SB", "Bisanga Solomɔ");
    namesMap.put("SC", "Sɛshɛlɛ");
    namesMap.put("SD", "Sudá");
    namesMap.put("SE", "Swédɛ");
    namesMap.put("SG", "Singapurɛ");
    namesMap.put("SH", "Sántu eleni");
    namesMap.put("SI", "Siloveni");
    namesMap.put("SK", "Silovaki");
    namesMap.put("SL", "Siera Leonɛ");
    namesMap.put("SM", "Sántu Marinɛ");
    namesMap.put("SN", "Senegalɛ");
    namesMap.put("SO", "Somali");
    namesMap.put("SR", "Surinamɛ");
    namesMap.put("ST", "Sao Tomé mpé Presipɛ");
    namesMap.put("SV", "Savadɔrɛ");
    namesMap.put("SY", "Sirí");
    namesMap.put("SZ", "Swazilandi");
    namesMap.put("TC", "Bisanga bya Turki mpé Kaiko");
    namesMap.put("TD", "Tsádi");
    namesMap.put("TH", "Tailandɛ");
    namesMap.put("TJ", "Tazikisitá");
    namesMap.put("TL", "Timorɛ ya Moniɛlɛ");
    namesMap.put("TM", "Tikɛménisitá");
    namesMap.put("TN", "Tinizi");
    namesMap.put("TR", "Tiliki");
    namesMap.put("TT", "Tinidadɛ mpé Tobago");
    namesMap.put("TW", "Taiwanin");
    namesMap.put("TZ", "Tanzani");
    namesMap.put("UA", "Ikrɛni");
    namesMap.put("US", "Ameriki");
    namesMap.put("UY", "Irigwei");
    namesMap.put("UZ", "Uzibɛkisitá");
    namesMap.put("VA", "Vatiká");
    namesMap.put("VC", "Sántu vesá mpé Gelenadinɛ");
    namesMap.put("VE", "Venézuela");
    namesMap.put("VG", "Bisanga bya Vierzi ya Angɛlɛtɛ́lɛ");
    namesMap.put("VI", "Bisanga bya Vierzi ya Ameriki");
    namesMap.put("VN", "Viyetinamɛ");
    namesMap.put("WF", "Walisɛ mpé Futuna");
    namesMap.put("YE", "Yemɛnɛ");
    namesMap.put("YT", "Mayotɛ");
    namesMap.put("ZA", "Afríka ya Súdi");
    namesMap.put("ZM", "Zambi");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AD": "Andorɛ",
        "AE": "Lɛmila alabo",
        "AF": "Afiganisitá",
        "AG": "Antiga mpé Barbuda",
        "AI": "Angiyɛ",
        "AL": "Alibani",
        "AM": "Amɛni",
        "AN": "Antiyɛ ya Olandɛ",
        "AO": "Angóla",
        "AR": "Arizantinɛ",
        "AS": "Samoa ya Ameriki",
        "AT": "Otilisi",
        "AU": "Ositáli",
        "AZ": "Azɛlɛbaizá",
        "BA": "Bosini mpé Hezegovine",
        "BB": "Barɛbadɛ",
        "BD": "Bengalidɛsi",
        "BE": "Beleziki",
        "BF": "Bukina Faso",
        "BG": "Biligari",
        "BH": "Bahrɛnɛ",
        "BJ": "Benɛ",
        "BN": "Brineyi",
        "BO": "Bolivi",
        "BR": "Brezílɛ",
        "BS": "Bahamasɛ",
        "BT": "Butáni",
        "BY": "Byelorisi",
        "BZ": "Belizɛ",
        "CA": "Kanada",
        "CD": "Repibiki demokratiki ya Kongó",
        "CF": "Repibiki ya Afríka ya Káti",
        "CG": "Kongo",
        "CH": "Swisɛ",
        "CI": "Kotídivualɛ",
        "CK": "Bisanga bya Kookɛ",
        "CL": "Síli",
        "CM": "Kamɛrune",
        "CN": "Sinɛ",
        "CO": "Kolombi",
        "CR": "Kositarika",
        "CS": "Serebi mpé Monténegro",
        "CU": "Kiba",
        "CV": "Bisanga bya Kapevɛrɛ",
        "CY": "Sípɛlɛ",
        "CZ": "Repibiki Tsekɛ",
        "DE": "Alemani",
        "DJ": "Dzibuti",
        "DK": "Danɛmarike",
        "DM": "Domínike",
        "DO": "Repibiki ya Domínikɛ",
        "DZ": "Alizɛri",
        "EC": "Ekwatɛ́lɛ",
        "EE": "Esitoni",
        "EG": "Ezípite",
        "ER": "Elitelɛ",
        "ES": "Esipanye",
        "ET": "Etsíopi",
        "FI": "Filandɛ",
        "FJ": "Fidzi",
        "FK": "Bisanga bya Maluni",
        "FM": "Mikronezi",
        "FR": "Falánsɛ",
        "GA": "Gabɔ",
        "GB": "Angɛlɛtɛ́lɛ",
        "GD": "Gelenadɛ",
        "GE": "Zorzi",
        "GF": "Giyanɛ ya Falánsɛ",
        "GH": "Gana",
        "GI": "Zibatalɛ",
        "GL": "Gowelande",
        "GM": "Gambi",
        "GN": "Ginɛ",
        "GP": "Gwadɛlupɛ",
        "GQ": "Ginɛ́kwatɛ́lɛ",
        "GR": "Geleki",
        "GT": "Gwatémala",
        "GU": "Gwamɛ",
        "GW": "Ginɛbisau",
        "GY": "Giyane",
        "HN": "Ondurasɛ",
        "HR": "Krowasi",
        "HT": "Ayiti",
        "HU": "Ongili",
        "ID": "Indonezi",
        "IE": "Irelandɛ",
        "IL": "Isirayelɛ",
        "IN": "Índɛ",
        "IO": "Mabelé ya Angɛlɛtɛ́lɛ na mbú ya Indiya",
        "IQ": "Iraki",
        "IR": "Irâ",
        "IS": "Isilandɛ",
        "IT": "Itali",
        "JM": "Zamaiki",
        "JO": "Zɔdani",
        "JP": "Zapɔ",
        "KG": "Kigizisitá",
        "KH": "Kambodza",
        "KM": "Komorɛ",
        "KN": "Sántu krístofe mpé Nevɛ̀s",
        "KP": "Korɛ ya nɔ́rdi",
        "KR": "Korɛ ya súdi",
        "KW": "Koweti",
        "KY": "Bisanga bya Kayíma",
        "KZ": "Kazakisitá",
        "LA": "Lawosi",
        "LB": "Libá",
        "LC": "Sántu lisi",
        "LI": "Lishɛteni",
        "LK": "Sirilanka",
        "LR": "Libériya",
        "LS": "Lesoto",
        "LT": "Litwani",
        "LU": "Likisambulu",
        "LV": "Letoni",
        "LY": "Libí",
        "MA": "Marokɛ",
        "MC": "Monako",
        "MD": "Molidavi",
        "MG": "Madagasikari",
        "MH": "Bisanga bya Marishalɛ",
        "MK": "Masedwanɛ",
        "ML": "Malí",
        "MN": "Mongolí",
        "MP": "Bisanga bya Marianɛ ya nɔ́rdi",
        "MQ": "Martiniki",
        "MR": "Moritani",
        "MS": "Mɔsera",
        "MT": "Malitɛ",
        "MU": "Morisɛ",
        "MV": "Madívɛ",
        "MX": "Meksike",
        "MY": "Malezi",
        "MZ": "Mozambíki",
        "NA": "Namibi",
        "NC": "Kaledoni ya sika",
        "NE": "Nizɛrɛ",
        "NF": "Esanga Norfokɛ",
        "NG": "Nizerya",
        "NI": "Nikaragwa",
        "NL": "Olandɛ",
        "NO": "Norivezɛ",
        "NP": "Nepálɛ",
        "NU": "Nyué",
        "NZ": "Zelandɛ ya sika",
        "OM": "Ománɛ",
        "PE": "Péru",
        "PF": "Polinezi ya Falánsɛ",
        "PG": "Papwazi Ginɛ ya sika",
        "PH": "Filipinɛ",
        "PK": "Pakisitá",
        "PL": "Poloni",
        "PM": "Sántu pététo mpé Mikelɔ",
        "PN": "Pikairni",
        "PR": "Pɔtoriko",
        "PS": "Palɛsine",
        "PT": "Putúlugɛsi",
        "PY": "Palagwei",
        "QA": "Katari",
        "RE": "Lenyo",
        "RO": "Romani",
        "RU": "Risí",
        "SA": "Alabi Sawuditɛ",
        "SB": "Bisanga Solomɔ",
        "SC": "Sɛshɛlɛ",
        "SD": "Sudá",
        "SE": "Swédɛ",
        "SG": "Singapurɛ",
        "SH": "Sántu eleni",
        "SI": "Siloveni",
        "SK": "Silovaki",
        "SL": "Siera Leonɛ",
        "SM": "Sántu Marinɛ",
        "SN": "Senegalɛ",
        "SO": "Somali",
        "SR": "Surinamɛ",
        "ST": "Sao Tomé mpé Presipɛ",
        "SV": "Savadɔrɛ",
        "SY": "Sirí",
        "SZ": "Swazilandi",
        "TC": "Bisanga bya Turki mpé Kaiko",
        "TD": "Tsádi",
        "TH": "Tailandɛ",
        "TJ": "Tazikisitá",
        "TL": "Timorɛ ya Moniɛlɛ",
        "TM": "Tikɛménisitá",
        "TN": "Tinizi",
        "TR": "Tiliki",
        "TT": "Tinidadɛ mpé Tobago",
        "TW": "Taiwanin",
        "TZ": "Tanzani",
        "UA": "Ikrɛni",
        "US": "Ameriki",
        "UY": "Irigwei",
        "UZ": "Uzibɛkisitá",
        "VA": "Vatiká",
        "VC": "Sántu vesá mpé Gelenadinɛ",
        "VE": "Venézuela",
        "VG": "Bisanga bya Vierzi ya Angɛlɛtɛ́lɛ",
        "VI": "Bisanga bya Vierzi ya Ameriki",
        "VN": "Viyetinamɛ",
        "WF": "Walisɛ mpé Futuna",
        "YE": "Yemɛnɛ",
        "YT": "Mayotɛ",
        "ZA": "Afríka ya Súdi",
        "ZM": "Zambi"
    };
  }-*/;
}
