/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.shared.impl.cldr;

// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA
//  cldrVersion=21.0
//  number=$Revision: 6546 $
//  date=$Date: 2012-02-07 13:32:35 -0500 (Tue, 07 Feb 2012) $
//  type=root

/**
 * Implementation of DateTimeFormatInfo for the "ee" locale.
 */
public class DateTimeFormatInfoImpl_ee extends DateTimeFormatInfoImpl {

  @Override
  public String[] ampms() {
    return new String[] {
        "ŋdi",
        "ɣetrɔ"
    };
  }

  @Override
  public String dateFormatFull() {
    return "EEEE, d MMMM y";
  }

  @Override
  public String dateFormatLong() {
    return "d MMMM y";
  }

  @Override
  public String dateFormatMedium() {
    return "d MMM y";
  }

  @Override
  public String dateFormatShort() {
    return "dd/MM/yyyy";
  }

  @Override
  public String dateTimeFull(String timePattern, String datePattern) {
    return timePattern + " " + datePattern;
  }

  @Override
  public String dateTimeLong(String timePattern, String datePattern) {
    return timePattern + " " + datePattern;
  }

  @Override
  public String dateTimeMedium(String timePattern, String datePattern) {
    return timePattern + " " + datePattern;
  }

  @Override
  public String dateTimeShort(String timePattern, String datePattern) {
    return timePattern + " " + datePattern;
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "Hafi Yesu Va Do ŋgɔ",
        "Yesu Ŋɔli"
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "hY",
        "Yŋ"
    };
  }

  @Override
  public String formatHour12Minute() {
    return "a h:mm";
  }

  @Override
  public String formatHour12MinuteSecond() {
    return "a h:mm:ss";
  }

  @Override
  public String formatMonthFullWeekdayDay() {
    return "EEEE, MMMM d";
  }

  @Override
  public String formatMonthNumDay() {
    return "M/d";
  }

  @Override
  public String formatYearMonthAbbrev() {
    return "MMM y";
  }

  @Override
  public String formatYearMonthAbbrevDay() {
    return "d MMM y";
  }

  @Override
  public String formatYearMonthFull() {
    return "MMMM y";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "d MMMM y";
  }

  @Override
  public String formatYearMonthNum() {
    return "M/y";
  }

  @Override
  public String formatYearMonthNumDay() {
    return "d/M/y";
  }

  @Override
  public String formatYearMonthWeekdayDay() {
    return "EEE, MMM d, y";
  }

  @Override
  public String formatYearQuarterFull() {
    return "QQQQ y";
  }

  @Override
  public String formatYearQuarterShort() {
    return "Q y";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "dzove",
        "dzodze",
        "tedoxe",
        "afɔfĩe",
        "dama",
        "masa",
        "siamlɔm",
        "deasiamime",
        "anyɔnyɔ",
        "kele",
        "adeɛmekpɔxe",
        "dzome"
    };
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] {
        "d",
        "d",
        "t",
        "a",
        "d",
        "m",
        "s",
        "d",
        "a",
        "k",
        "a",
        "d"
    };
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "dzv",
        "dzd",
        "ted",
        "afɔ",
        "dam",
        "mas",
        "sia",
        "dea",
        "any",
        "kel",
        "ade",
        "dzm"
    };
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "memama ene ƒe akpa gbãtɔ",
        "memama ene ƒe akpa evelia",
        "memama ene ƒe akpa etɔ̃lia",
        "memama ene ƒe akpa enelia"
    };
  }

  @Override
  public String[] quartersShort() {
    return new String[] {
        "q1",
        "q2",
        "q3",
        "q4"
    };
  }

  @Override
  public String timeFormatFull() {
    return "a h:mm:ss zzzz";
  }

  @Override
  public String timeFormatLong() {
    return "a h:mm:ss z";
  }

  @Override
  public String timeFormatMedium() {
    return "a h:mm:ss";
  }

  @Override
  public String timeFormatShort() {
    return "a h:mm";
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "kɔsiɖa",
        "dzoɖa",
        "blaɖa",
        "kuɖa",
        "yawoɖa",
        "fiɖa",
        "memleɖa"
    };
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "k",
        "d",
        "b",
        "k",
        "y",
        "f",
        "m"
    };
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "kɔs",
        "dzo",
        "bla",
        "kuɖ",
        "yaw",
        "fiɖ",
        "mem"
    };
  }
}
