/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.view;

import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.view.GraphGeneratorSupport;
import org.apache.camel.view.NodeData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlGraphGenerator
extends GraphGeneratorSupport {
    private boolean addUrl = true;

    public XmlGraphGenerator(String dir) {
        super(dir, ".xml");
    }

    @Override
    protected void generateFile(PrintWriter writer, Map<String, List<RouteDefinition>> map) {
        writer.println("<?xml version='1.0' encoding='UTF-8'?>");
        writer.println("<Graph>");
        writer.println();
        if (map.size() > 0) {
            writer.println("<Node id='root' name='Camel Routes' description='Collection of Camel Routes' nodeType='root'/>");
        }
        this.printRoutes(writer, map);
        writer.println();
        writer.println("</Graph>");
    }

    protected void printRoutes(PrintWriter writer, Map<String, List<RouteDefinition>> map) {
        Set<Map.Entry<String, List<RouteDefinition>>> entries = map.entrySet();
        for (Map.Entry<String, List<RouteDefinition>> entry : entries) {
            String group = entry.getKey();
            this.printRoutes(writer, group, entry.getValue());
        }
    }

    protected void printRoutes(PrintWriter writer, String group, List<RouteDefinition> routes) {
        if ((group = this.encode(group)) != null) {
            int idx = group.lastIndexOf(46);
            String name = group;
            if (idx > 0 && idx < group.length() - 1) {
                name = group.substring(idx + 1);
            }
            writer.println("<Node id='" + group + "' name='" + name + "' description='" + group + "' nodeType='group'/>");
            writer.println("<Edge fromID='root' toID='" + group + "'/>");
        }
        for (RouteDefinition route : routes) {
            List<FromDefinition> inputs = route.getInputs();
            boolean first = true;
            for (FromDefinition input : inputs) {
                NodeData nodeData = this.getNodeData(input);
                if (first) {
                    first = false;
                    if (group != null) {
                        writer.println("<Edge fromID='" + group + "' toID='" + this.encode(nodeData.id) + "'/>");
                    }
                }
                this.printRoute(writer, route, nodeData);
            }
            writer.println();
        }
    }

    protected void printRoute(PrintWriter writer, RouteDefinition route, NodeData nodeData) {
        this.printNode(writer, nodeData);
        NodeData from = nodeData;
        for (ProcessorDefinition output : route.getOutputs()) {
            NodeData newData;
            from = newData = this.printNode(writer, from, output);
        }
    }

    protected NodeData printNode(PrintWriter writer, NodeData fromData, ProcessorDefinition node) {
        List<ProcessorDefinition> outputs;
        if (node instanceof MulticastDefinition) {
            List<ProcessorDefinition> outputs2 = node.getOutputs();
            for (ProcessorDefinition output : outputs2) {
                this.printNode(writer, fromData, output);
            }
            return fromData;
        }
        NodeData toData = this.getNodeData(node);
        this.printNode(writer, toData);
        if (fromData != null) {
            writer.print("<Edge fromID=\"");
            writer.print(this.encode(fromData.id));
            writer.print("\" toID=\"");
            writer.print(this.encode(toData.id));
            String association = toData.edgeLabel;
            if (ObjectHelper.isEmpty(association)) {
                writer.print("\" association=\"");
                writer.print(this.encode(association));
            }
            writer.println("\"/>");
        }
        if ((outputs = toData.outputs) != null) {
            for (ProcessorDefinition output : outputs) {
                NodeData newData = this.printNode(writer, toData, output);
                if (this.isMulticastNode(node)) continue;
                toData = newData;
            }
        }
        return toData;
    }

    protected void printNode(PrintWriter writer, NodeData data) {
        if (!data.nodeWritten) {
            data.nodeWritten = true;
            writer.println();
            writer.print("<Node id=\"");
            writer.print(this.encode(data.id));
            writer.print("\" name=\"");
            String name = data.label;
            if (ObjectHelper.isEmpty(name)) {
                name = data.tooltop;
            }
            writer.print(this.encode(name));
            writer.print("\" nodeType=\"");
            String nodeType = data.image;
            if (ObjectHelper.isEmpty(nodeType) && ObjectHelper.isEmpty(nodeType = data.shape)) {
                nodeType = "node";
            }
            writer.print(this.encode(nodeType));
            writer.print("\" description=\"");
            writer.print(this.encode(data.tooltop));
            if (this.addUrl) {
                writer.print("\" url=\"");
                writer.print(this.encode(data.url));
            }
            writer.println("\"/>");
        }
    }

    protected String encode(String text) {
        if (text == null) {
            return "";
        }
        return text.replaceAll("\"", "&quot;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("&", "&amp;");
    }
}

