/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.alerts;

import java.util.Iterator;
import java.util.List;
import org.apache.helix.alerts.Tuple;

public abstract class Operator {
    public int minInputTupleLists;
    public int maxInputTupleLists;
    public int numOutputTupleLists = -1;
    public boolean inputOutputTupleListsCountsEqual = false;

    public Tuple<String> multiplyTuples(Tuple<String> tup1, Tuple<String> tup2) {
        Tuple<String> smallerTup;
        Tuple<String> largerTup;
        if (tup1 == null) {
            return tup2;
        }
        if (tup2 == null) {
            return tup1;
        }
        Tuple<String> outputTup = new Tuple<String>();
        if (tup1.size() >= tup2.size()) {
            largerTup = tup1;
            smallerTup = tup2;
        } else {
            largerTup = tup2;
            smallerTup = tup1;
        }
        int gap = largerTup.size() - smallerTup.size();
        for (int i = 0; i < largerTup.size(); ++i) {
            if (i < gap) {
                outputTup.add(largerTup.getElement(i));
                continue;
            }
            double elementProduct = 0.0;
            elementProduct = Double.parseDouble(largerTup.getElement(i)) * Double.parseDouble(smallerTup.getElement(i - gap));
            outputTup.add(String.valueOf(elementProduct));
        }
        return outputTup;
    }

    public Tuple<String> sumTuples(Tuple<String> tup1, Tuple<String> tup2) {
        Tuple<String> smallerTup;
        Tuple<String> largerTup;
        if (tup1 == null) {
            return tup2;
        }
        if (tup2 == null) {
            return tup1;
        }
        Tuple<String> outputTup = new Tuple<String>();
        if (tup1.size() >= tup2.size()) {
            largerTup = tup1;
            smallerTup = tup2;
        } else {
            largerTup = tup2;
            smallerTup = tup1;
        }
        int gap = largerTup.size() - smallerTup.size();
        for (int i = 0; i < largerTup.size(); ++i) {
            if (i < gap) {
                outputTup.add(largerTup.getElement(i));
                continue;
            }
            double elementSum = 0.0;
            elementSum = Double.parseDouble(largerTup.getElement(i)) + Double.parseDouble(smallerTup.getElement(i - gap));
            outputTup.add(String.valueOf(elementSum));
        }
        return outputTup;
    }

    public abstract List<Iterator<Tuple<String>>> execute(List<Iterator<Tuple<String>>> var1);
}

