/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.iostream;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.iostream.IoStreamChannel;
import io.netty.channel.iostream.IoStreamChannelSink;
import io.netty.util.internal.ExecutorUtil;
import java.util.concurrent.ExecutorService;

public class IoStreamChannelFactory
implements ChannelFactory {
    private final ChannelGroup channels = new DefaultChannelGroup("IOStreamChannelFactory-ChannelGroup");
    private final ExecutorService executorService;

    public IoStreamChannelFactory(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public Channel newChannel(ChannelPipeline pipeline) {
        IoStreamChannelSink sink = new IoStreamChannelSink(this.executorService);
        IoStreamChannel channel = new IoStreamChannel(this, pipeline, sink);
        sink.setChannel(channel);
        this.channels.add(channel);
        return channel;
    }

    @Override
    public void releaseExternalResources() {
        ChannelGroupFuture close = this.channels.close();
        close.awaitUninterruptibly();
        ExecutorUtil.terminate(this.executorService);
    }
}

