/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.nio;

import io.netty.buffer.ChannelBufferFactory;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.Channels;
import io.netty.channel.ReceiveBufferSizePredictor;
import io.netty.channel.socket.nio.AbstractNioChannel;
import io.netty.channel.socket.nio.AbstractNioWorker;
import io.netty.channel.socket.nio.NioDatagramChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.concurrent.Executor;

class NioDatagramWorker
extends AbstractNioWorker {
    NioDatagramWorker(Executor executor) {
        super(executor);
    }

    @Override
    protected boolean read(SelectionKey key) {
        NioDatagramChannel channel = (NioDatagramChannel)key.attachment();
        ReceiveBufferSizePredictor predictor = channel.getConfig().getReceiveBufferSizePredictor();
        ChannelBufferFactory bufferFactory = channel.getConfig().getBufferFactory();
        DatagramChannel nioChannel = (DatagramChannel)key.channel();
        ByteBuffer byteBuffer = ByteBuffer.allocate(predictor.nextReceiveBufferSize()).order(bufferFactory.getDefaultOrder());
        boolean failure = true;
        SocketAddress remoteAddress = null;
        try {
            remoteAddress = nioChannel.receive(byteBuffer);
            failure = false;
        }
        catch (ClosedChannelException e) {
        }
        catch (Throwable t) {
            Channels.fireExceptionCaught(channel, t);
        }
        if (remoteAddress != null) {
            byteBuffer.flip();
            int readBytes = byteBuffer.remaining();
            if (readBytes > 0) {
                predictor.previousReceiveBufferSize(readBytes);
                Channels.fireMessageReceived(channel, (Object)bufferFactory.getBuffer(byteBuffer), remoteAddress);
            }
        }
        if (failure) {
            key.cancel();
            this.close(channel, Channels.succeededFuture(channel));
            return false;
        }
        return true;
    }

    @Override
    protected boolean scheduleWriteIfNecessary(AbstractNioChannel<?> channel) {
        Thread workerThread = this.thread;
        if (workerThread == null || Thread.currentThread() != workerThread) {
            Selector selector;
            if (channel.writeTaskInTaskQueue.compareAndSet(false, true)) {
                boolean offered = this.writeTaskQueue.offer(channel.writeTask);
                assert (offered);
            }
            if ((selector = this.selector) != null && this.wakenUp.compareAndSet(false, true)) {
                selector.wakeup();
            }
            return true;
        }
        return false;
    }

    static void disconnect(NioDatagramChannel channel, ChannelFuture future) {
        boolean connected = channel.isConnected();
        try {
            channel.getDatagramChannel().disconnect();
            future.setSuccess();
            if (connected) {
                Channels.fireChannelDisconnected(channel);
            }
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    @Override
    protected Runnable createRegisterTask(AbstractNioChannel<?> channel, ChannelFuture future) {
        return new ChannelRegistionTask((NioDatagramChannel)channel, future);
    }

    private final class ChannelRegistionTask
    implements Runnable {
        private final NioDatagramChannel channel;
        private final ChannelFuture future;

        ChannelRegistionTask(NioDatagramChannel channel, ChannelFuture future) {
            this.channel = channel;
            this.future = future;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InetSocketAddress localAddress = this.channel.getLocalAddress();
            if (localAddress == null) {
                if (this.future != null) {
                    this.future.setFailure(new ClosedChannelException());
                }
                NioDatagramWorker.this.close(this.channel, Channels.succeededFuture(this.channel));
                return;
            }
            try {
                Object object = this.channel.interestOpsLock;
                synchronized (object) {
                    this.channel.getDatagramChannel().register(NioDatagramWorker.this.selector, this.channel.getRawInterestOps(), this.channel);
                }
                if (this.future != null) {
                    this.future.setSuccess();
                }
            }
            catch (ClosedChannelException e) {
                if (this.future != null) {
                    this.future.setFailure(e);
                }
                NioDatagramWorker.this.close(this.channel, Channels.succeededFuture(this.channel));
                throw new ChannelException("Failed to register a socket to the selector.", e);
            }
        }
    }
}

