/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.websocketx.sslserver;

import io.netty.logging.InternalLogger;
import io.netty.logging.InternalLoggerFactory;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.Security;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;

public final class WebSocketSslServerSslContext {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocketSslServerSslContext.class);
    private static final String PROTOCOL = "TLS";
    private SSLContext _serverContext;

    public static WebSocketSslServerSslContext getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private WebSocketSslServerSslContext() {
        try {
            String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
            if (algorithm == null) {
                algorithm = "SunX509";
            }
            SSLContext serverContext = null;
            try {
                String keyStoreFilePath = System.getProperty("keystore.file.path");
                String keyStoreFilePassword = System.getProperty("keystore.file.password");
                KeyStore ks = KeyStore.getInstance("JKS");
                FileInputStream fin = new FileInputStream(keyStoreFilePath);
                ks.load(fin, keyStoreFilePassword.toCharArray());
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
                kmf.init(ks, keyStoreFilePassword.toCharArray());
                serverContext = SSLContext.getInstance(PROTOCOL);
                serverContext.init(kmf.getKeyManagers(), null, null);
            }
            catch (Exception e) {
                throw new Error("Failed to initialize the server-side SSLContext", e);
            }
            this._serverContext = serverContext;
        }
        catch (Exception ex) {
            if (logger.isErrorEnabled()) {
                logger.error("Error initializing SslContextManager. " + ex.getMessage(), ex);
            }
            System.exit(1);
        }
    }

    public SSLContext getServerContext() {
        return this._serverContext;
    }

    private static class SingletonHolder {
        public static final WebSocketSslServerSslContext INSTANCE = new WebSocketSslServerSslContext();

        private SingletonHolder() {
        }
    }
}

