/*
 * Decompiled with CFR 0.152.
 */
package org.kie.commons.java.nio.file.api;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.kie.commons.java.nio.file.FileSystemNotFoundException;
import org.kie.commons.java.nio.file.spi.FileSystemProvider;
import org.kie.commons.validation.Preconditions;

public final class FileSystemProviders {
    private FileSystemProviders() {
    }

    public static FileSystemProvider getDefaultProvider() throws ServiceConfigurationError {
        return FileSystemProvidersHolder.installedProviders.get(0);
    }

    public static FileSystemProvider resolveProvider(URI uri) {
        Preconditions.checkNotNull((String)"uri", (Object)uri);
        return FileSystemProviders.getProvider(uri.getScheme());
    }

    private static FileSystemProvider getProvider(String scheme) throws FileSystemNotFoundException, ServiceConfigurationError {
        Preconditions.checkNotEmpty((String)"scheme", (String)scheme);
        FileSystemProvider fileSystemProvider = FileSystemProvidersHolder.mapOfinstalledProviders.get(scheme);
        if (fileSystemProvider == null) {
            throw new FileSystemNotFoundException("Provider '" + scheme + "' not found");
        }
        return fileSystemProvider;
    }

    public static List<FileSystemProvider> installedProviders() throws ServiceConfigurationError {
        return FileSystemProvidersHolder.installedProviders;
    }

    private static class FileSystemProvidersHolder {
        static List<FileSystemProvider> installedProviders = FileSystemProvidersHolder.buildProviders();
        static Map<String, FileSystemProvider> mapOfinstalledProviders = FileSystemProvidersHolder.buildProvidersMap();

        private FileSystemProvidersHolder() {
        }

        private static synchronized List<FileSystemProvider> buildProviders() {
            ServiceLoader<FileSystemProvider> providers = ServiceLoader.load(FileSystemProvider.class);
            if (providers == null) {
                return Collections.emptyList();
            }
            ArrayList<FileSystemProvider> result = new ArrayList<FileSystemProvider>();
            for (FileSystemProvider provider : providers) {
                result.add(provider);
            }
            return Collections.unmodifiableList(result);
        }

        private static synchronized Map<String, FileSystemProvider> buildProvidersMap() {
            HashMap<String, FileSystemProvider> result = new HashMap<String, FileSystemProvider>(installedProviders.size() + 1);
            for (int i = 0; i < installedProviders.size(); ++i) {
                FileSystemProvider provider = installedProviders.get(i);
                if (i == 0) {
                    provider.forceAsDefault();
                    result.put("default", provider);
                }
                result.put(provider.getScheme(), provider);
            }
            return Collections.unmodifiableMap(result);
        }
    }
}

