/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.server.auth;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.kie.commons.validation.Preconditions;
import org.uberfire.security.SecurityContext;
import org.uberfire.security.auth.AuthenticationException;
import org.uberfire.security.auth.AuthenticationScheme;
import org.uberfire.security.auth.Credential;
import org.uberfire.security.impl.auth.UsernamePasswordCredential;
import org.uberfire.security.server.HttpSecurityContext;

public class FormAuthenticationScheme
implements AuthenticationScheme {
    public boolean isAuthenticationRequest(SecurityContext context) {
        HttpSecurityContext httpSecurityContext = (HttpSecurityContext)Preconditions.checkInstanceOf((String)"context", (Object)context, HttpSecurityContext.class);
        return httpSecurityContext.getRequest().getRequestURI().contains("/j_security_check");
    }

    public void challengeClient(SecurityContext context) {
        HttpSecurityContext httpSecurityContext = (HttpSecurityContext)Preconditions.checkInstanceOf((String)"context", (Object)context, HttpSecurityContext.class);
        RequestDispatcher rd = httpSecurityContext.getRequest().getRequestDispatcher("/login.jsp");
        if (rd == null) {
            throw new RuntimeException("Unable to resolve RequestDispatcher.");
        }
        try {
            httpSecurityContext.getResponse().setStatus(401);
            rd.forward((ServletRequest)httpSecurityContext.getRequest(), (ServletResponse)httpSecurityContext.getResponse());
        }
        catch (Exception e) {
            throw new AuthenticationException(e);
        }
    }

    public Credential buildCredential(SecurityContext context) {
        HttpSecurityContext httpSecurityContext = (HttpSecurityContext)Preconditions.checkInstanceOf((String)"context", (Object)context, HttpSecurityContext.class);
        String userName = httpSecurityContext.getRequest().getParameter("j_username");
        String password = httpSecurityContext.getRequest().getParameter("j_password");
        if (userName == null || password == null) {
            return null;
        }
        return new UsernamePasswordCredential(userName, (Object)password);
    }
}

