/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.examples;

import org.apache.helix.controller.HelixControllerMain;
import org.apache.helix.examples.DummyParticipant;
import org.apache.helix.manager.zk.ZKHelixAdmin;
import org.apache.helix.manager.zk.ZNRecordSerializer;
import org.apache.helix.manager.zk.ZkClient;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.model.builder.AutoModeISBuilder;
import org.apache.helix.model.builder.AutoRebalanceModeISBuilder;
import org.apache.helix.model.builder.CustomModeISBuilder;
import org.apache.helix.model.builder.IdealStateBuilder;
import org.apache.helix.tools.StateModelConfigGenerator;

public class IdealStateBuilderExample {
    private static String buildPartitionName(String resourceName, int partitionNum) {
        return resourceName + "_" + partitionNum;
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            System.err.println("USAGE: java IdealStateBuilderExample zkAddress clusterName idealStateMode (AUTO, AUTO_REBALANCE, or CUSTOMIZED)");
            System.exit(1);
        }
        final String zkAddr = args[0];
        final String clusterName = args[1];
        IdealState.IdealStateModeProperty idealStateMode = IdealState.IdealStateModeProperty.valueOf(args[2].toUpperCase());
        ZkClient zkclient = new ZkClient(zkAddr, 30000, 60000, new ZNRecordSerializer());
        ZKHelixAdmin admin = new ZKHelixAdmin(zkclient);
        admin.addCluster(clusterName, true);
        admin.addStateModelDef(clusterName, "MasterSlave", new StateModelDefinition(StateModelConfigGenerator.generateConfigForMasterSlave()));
        int n = 2;
        for (int i = 0; i < n; ++i) {
            int port = 12918 + i;
            InstanceConfig config = new InstanceConfig("localhost_" + port);
            config.setHostName("localhost");
            config.setPort(Integer.toString(port));
            config.setInstanceEnabled(true);
            admin.addInstance(clusterName, config);
        }
        String resourceName = "TestDB";
        IdealState idealState = null;
        switch (idealStateMode) {
            case AUTO: {
                IdealStateBuilder builder = new AutoModeISBuilder(resourceName);
                builder.setStateModel("MasterSlave").setNumPartitions(2).setNumReplica(2);
                ((AutoModeISBuilder)builder).assignPreferenceList(IdealStateBuilderExample.buildPartitionName(resourceName, 0), "localhost_12918", "localhost_12919").assignPreferenceList(IdealStateBuilderExample.buildPartitionName(resourceName, 1), "localhost_12919", "localhost_12918");
                idealState = builder.build();
                break;
            }
            case AUTO_REBALANCE: {
                IdealStateBuilder builder = new AutoRebalanceModeISBuilder(resourceName);
                builder.setStateModel("MasterSlave").setNumPartitions(2).setNumReplica(2).setMaxPartitionsPerNode(2);
                ((AutoRebalanceModeISBuilder)builder).add(IdealStateBuilderExample.buildPartitionName(resourceName, 0)).add(IdealStateBuilderExample.buildPartitionName(resourceName, 1));
                idealState = builder.build();
                break;
            }
            case CUSTOMIZED: {
                IdealStateBuilder builder = new CustomModeISBuilder(resourceName);
                builder.setStateModel("MasterSlave").setNumPartitions(2).setNumReplica(2);
                ((CustomModeISBuilder)builder).assignInstanceAndState(IdealStateBuilderExample.buildPartitionName(resourceName, 0), "localhost_12918", "MASTER").assignInstanceAndState(IdealStateBuilderExample.buildPartitionName(resourceName, 0), "localhost_12919", "SLAVE").assignInstanceAndState(IdealStateBuilderExample.buildPartitionName(resourceName, 1), "localhost_12918", "SLAVE").assignInstanceAndState(IdealStateBuilderExample.buildPartitionName(resourceName, 1), "localhost_12919", "MASTER");
                idealState = builder.build();
                break;
            }
        }
        admin.addResource(clusterName, resourceName, idealState);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    HelixControllerMain.main(new String[]{"--zkSvr", zkAddr, "--cluster", clusterName});
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
        for (int i = 0; i < n; ++i) {
            int port = 12918 + i;
            final String instanceName = "localhost_" + port;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    DummyParticipant.main(new String[]{zkAddr, clusterName, instanceName});
                }
            }).start();
        }
    }
}

