/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.participant.statemachine;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.helix.messaging.handling.BatchMessageWrapper;
import org.apache.helix.participant.statemachine.StateModel;

public abstract class StateModelFactory<T extends StateModel> {
    private ConcurrentMap<String, T> _stateModelMap = new ConcurrentHashMap<String, T>();
    private final ConcurrentMap<String, BatchMessageWrapper> _batchMsgWrapperMap = new ConcurrentHashMap<String, BatchMessageWrapper>();

    public abstract T createNewStateModel(String var1);

    public T createAndAddStateModel(String partitionName) {
        T stateModel = this.createNewStateModel(partitionName);
        this._stateModelMap.put(partitionName, stateModel);
        return stateModel;
    }

    public T getStateModel(String partitionName) {
        return (T)((StateModel)this._stateModelMap.get(partitionName));
    }

    public Map<String, T> getStateModelMap() {
        return this._stateModelMap;
    }

    public BatchMessageWrapper createBatchMessageWrapper(String resourceName) {
        return new BatchMessageWrapper();
    }

    public BatchMessageWrapper createAndAddBatchMessageWrapper(String resourceName) {
        BatchMessageWrapper wrapper = this.createBatchMessageWrapper(resourceName);
        this._batchMsgWrapperMap.put(resourceName, wrapper);
        return wrapper;
    }

    public BatchMessageWrapper getBatchMessageWrapper(String resourceName) {
        return (BatchMessageWrapper)this._batchMsgWrapperMap.get(resourceName);
    }
}

