/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.impl.DefaultComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SedaComponent
extends DefaultComponent {
    protected final int maxConcurrentConsumers = 500;
    private final Map<String, BlockingQueue<Exchange>> queues = new HashMap<String, BlockingQueue<Exchange>>();

    public synchronized BlockingQueue<Exchange> createQueue(String uri, Map<String, Object> parameters) {
        String key = this.getQueueKey(uri);
        if (this.queues.containsKey(key)) {
            return this.queues.get(key);
        }
        Integer size = this.getAndRemoveParameter(parameters, "size", Integer.class);
        LinkedBlockingQueue<Exchange> queue = size != null && size > 0 ? new LinkedBlockingQueue(size) : new LinkedBlockingQueue<Exchange>();
        this.queues.put(key, queue);
        return queue;
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        int consumers = this.getAndRemoveParameter(parameters, "concurrentConsumers", Integer.class, 1);
        boolean limitConcurrentConsumers = this.getAndRemoveParameter(parameters, "limitConcurrentConsumers", Boolean.class, true);
        if (limitConcurrentConsumers && consumers > 500) {
            throw new IllegalArgumentException("The limitConcurrentConsumers flag in set to true. ConcurrentConsumers cannot be set at a value greater than 500 was " + consumers);
        }
        SedaEndpoint answer = new SedaEndpoint(uri, this, this.createQueue(uri, parameters), consumers);
        answer.configureProperties(parameters);
        return answer;
    }

    protected String getQueueKey(String uri) {
        if (uri.contains("?")) {
            uri = uri.substring(0, uri.indexOf(63));
        }
        return uri;
    }

    @Override
    protected void doStop() throws Exception {
        this.queues.clear();
        super.doStop();
    }
}

