/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractChannelBuffer;
import io.netty.buffer.ChannelBuffer;
import io.netty.buffer.ChannelBufferFactory;
import io.netty.buffer.WrappedChannelBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

public class ReadOnlyChannelBuffer
extends AbstractChannelBuffer
implements WrappedChannelBuffer {
    private final ChannelBuffer buffer;

    public ReadOnlyChannelBuffer(ChannelBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        this.buffer = buffer;
        this.setIndex(buffer.readerIndex(), buffer.writerIndex());
    }

    private ReadOnlyChannelBuffer(ReadOnlyChannelBuffer buffer) {
        this.buffer = buffer.buffer;
        this.setIndex(buffer.readerIndex(), buffer.writerIndex());
    }

    @Override
    public ChannelBuffer unwrap() {
        return this.buffer;
    }

    @Override
    public ChannelBufferFactory factory() {
        return this.buffer.factory();
    }

    @Override
    public ByteOrder order() {
        return this.buffer.order();
    }

    @Override
    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public byte[] array() {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int arrayOffset() {
        throw new ReadOnlyBufferException();
    }

    @Override
    public void discardReadBytes() {
        throw new ReadOnlyBufferException();
    }

    @Override
    public void setByte(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public void setBytes(int index, ChannelBuffer src, int srcIndex, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public void setBytes(int index, byte[] src, int srcIndex, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public void setBytes(int index, ByteBuffer src) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public void setShort(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public void setMedium(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public void setInt(int index, int value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public void setLong(int index, long value) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int setBytes(int index, InputStream in, int length) throws IOException {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        throw new ReadOnlyBufferException();
    }

    @Override
    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        return this.buffer.getBytes(index, out, length);
    }

    @Override
    public void getBytes(int index, OutputStream out, int length) throws IOException {
        this.buffer.getBytes(index, out, length);
    }

    @Override
    public void getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.buffer.getBytes(index, dst, dstIndex, length);
    }

    @Override
    public void getBytes(int index, ChannelBuffer dst, int dstIndex, int length) {
        this.buffer.getBytes(index, dst, dstIndex, length);
    }

    @Override
    public void getBytes(int index, ByteBuffer dst) {
        this.buffer.getBytes(index, dst);
    }

    @Override
    public ChannelBuffer duplicate() {
        return new ReadOnlyChannelBuffer(this);
    }

    @Override
    public ChannelBuffer copy(int index, int length) {
        return this.buffer.copy(index, length);
    }

    @Override
    public ChannelBuffer slice(int index, int length) {
        return new ReadOnlyChannelBuffer(this.buffer.slice(index, length));
    }

    @Override
    public byte getByte(int index) {
        return this.buffer.getByte(index);
    }

    @Override
    public short getShort(int index) {
        return this.buffer.getShort(index);
    }

    @Override
    public int getUnsignedMedium(int index) {
        return this.buffer.getUnsignedMedium(index);
    }

    @Override
    public int getInt(int index) {
        return this.buffer.getInt(index);
    }

    @Override
    public long getLong(int index) {
        return this.buffer.getLong(index);
    }

    @Override
    public ByteBuffer toByteBuffer(int index, int length) {
        return this.buffer.toByteBuffer(index, length).asReadOnlyBuffer();
    }

    @Override
    public ByteBuffer[] toByteBuffers(int index, int length) {
        ByteBuffer[] bufs = this.buffer.toByteBuffers(index, length);
        for (int i = 0; i < bufs.length; ++i) {
            bufs[i] = bufs[i].asReadOnlyBuffer();
        }
        return bufs;
    }

    @Override
    public int capacity() {
        return this.buffer.capacity();
    }
}

