/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.proxy;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.socket.nio.NioClientSocketChannelFactory;
import io.netty.channel.socket.nio.NioServerSocketChannelFactory;
import io.netty.example.proxy.HexDumpProxyPipelineFactory;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class HexDumpProxy {
    private final int localPort;
    private final String remoteHost;
    private final int remotePort;

    public HexDumpProxy(int localPort, String remoteHost, int remotePort) {
        this.localPort = localPort;
        this.remoteHost = remoteHost;
        this.remotePort = remotePort;
    }

    public void run() {
        System.err.println("Proxying *:" + this.localPort + " to " + this.remoteHost + ':' + this.remotePort + " ...");
        ExecutorService executor = Executors.newCachedThreadPool();
        ServerBootstrap sb = new ServerBootstrap(new NioServerSocketChannelFactory(executor, executor));
        NioClientSocketChannelFactory cf = new NioClientSocketChannelFactory(executor, executor);
        sb.setPipelineFactory(new HexDumpProxyPipelineFactory(cf, this.remoteHost, this.remotePort));
        sb.bind(new InetSocketAddress(this.localPort));
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            System.err.println("Usage: " + HexDumpProxy.class.getSimpleName() + " <local port> <remote host> <remote port>");
            return;
        }
        int localPort = Integer.parseInt(args[0]);
        String remoteHost = args[1];
        int remotePort = Integer.parseInt(args[2]);
        new HexDumpProxy(localPort, remoteHost, remotePort).run();
    }
}

