/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=21.0
//  number=$Revision: 6546 Google $
//  type=root
//  date=$Date: 2012-02-07 13:32:35 -0500 (Tue, 07 Feb 2012) $


/**
 * Localized names for the "hr" locale.
 */
public class LocalizedNamesImpl_hr extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "HR",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "AX",
        "AL",
        "DZ",
        "AS",
        "VI",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AR",
        "AM",
        "AW",
        "AU",
        "AT",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BY",
        "BW",
        "BO",
        "BA",
        "CX",
        "BQ",
        "BR",
        "VG",
        "IO",
        "BN",
        "BG",
        "BF",
        "BI",
        "BT",
        "EA",
        "CY",
        "ME",
        "CW",
        "TD",
        "CZ",
        "CL",
        "DK",
        "CD",
        "DG",
        "DM",
        "DO",
        "DJ",
        "EG",
        "EC",
        "GQ",
        "SV",
        "ER",
        "EE",
        "ET",
        "EU",
        "FK",
        "FO",
        "FJ",
        "PH",
        "FI",
        "FR",
        "GF",
        "PF",
        "TF",
        "GA",
        "GM",
        "GH",
        "GI",
        "VA",
        "GR",
        "GD",
        "GL",
        "GE",
        "GP",
        "GU",
        "GG",
        "GY",
        "GT",
        "GN",
        "GW",
        "HT",
        "HN",
        "HK",
        "HR",
        "IN",
        "ID",
        "IQ",
        "IR",
        "IE",
        "IS",
        "TL",
        "IT",
        "IL",
        "JM",
        "JP",
        "YE",
        "JE",
        "JO",
        "GS",
        "KR",
        "ZA",
        "KY",
        "KH",
        "CM",
        "CA",
        "IC",
        "QA",
        "KZ",
        "KE",
        "CN",
        "KG",
        "KI",
        "CC",
        "CO",
        "KM",
        "CG",
        "CR",
        "CU",
        "CK",
        "KW",
        "LA",
        "LV",
        "LS",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MG",
        "HU",
        "YT",
        "MO",
        "MK",
        "MW",
        "MV",
        "MY",
        "ML",
        "MT",
        "MA",
        "MH",
        "MQ",
        "MU",
        "MR",
        "MX",
        "FX",
        "MM",
        "FM",
        "MD",
        "MC",
        "MN",
        "MS",
        "MZ",
        "NA",
        "NR",
        "NP",
        "NE",
        "NG",
        "NI",
        "NU",
        "NL",
        "AN",
        "NO",
        "NC",
        "NZ",
        "DE",
        "CI",
        "OM",
        "QO",
        "AC",
        "BV",
        "CP",
        "HM",
        "IM",
        "NF",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PL",
        "PR",
        "PT",
        "RE",
        "RW",
        "RO",
        "RU",
        "WS",
        "SM",
        "SA",
        "SC",
        "SN",
        "SL",
        "SG",
        "SY",
        "US",
        "KP",
        "MP",
        "SK",
        "SI",
        "SB",
        "SO",
        "RS",
        "CS",
        "CF",
        "SS",
        "SD",
        "SR",
        "SJ",
        "SZ",
        "SH",
        "LC",
        "BL",
        "KN",
        "MF",
        "PM",
        "ST",
        "VC",
        "SX",
        "ES",
        "LK",
        "SE",
        "CH",
        "TJ",
        "TH",
        "TW",
        "TZ",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TM",
        "TC",
        "TR",
        "TV",
        "UG",
        "UM",
        "AE",
        "UA",
        "UY",
        "UZ",
        "VU",
        "GB",
        "VE",
        "VN",
        "WF",
        "ZM",
        "EH",
        "CV",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Svijet");
    namesMap.put("002", "Afrika");
    namesMap.put("003", "Sjevernoamerički kontinent");
    namesMap.put("005", "Južna Amerika");
    namesMap.put("009", "Oceanija");
    namesMap.put("011", "Zapadna Afrika");
    namesMap.put("013", "Centralna Amerika");
    namesMap.put("014", "Istočna Afrika");
    namesMap.put("015", "Sjeverna Afrika");
    namesMap.put("017", "Središnja Afrika");
    namesMap.put("018", "Južna Afrika");
    namesMap.put("019", "Amerike");
    namesMap.put("021", "Sjeverna Amerika");
    namesMap.put("029", "Karibi");
    namesMap.put("030", "Istočna Azija");
    namesMap.put("034", "Južna Azija");
    namesMap.put("035", "Jugoistočna Azija");
    namesMap.put("039", "Južna Europa");
    namesMap.put("053", "Australija i Novi Zeland");
    namesMap.put("054", "Melanezija");
    namesMap.put("057", "Mikronezki oblast");
    namesMap.put("061", "Polinezija");
    namesMap.put("142", "Azija");
    namesMap.put("143", "Srednja Azija");
    namesMap.put("145", "Zapadna Azija");
    namesMap.put("150", "Europa");
    namesMap.put("151", "Istočna Europa");
    namesMap.put("154", "Sjeverna Europa");
    namesMap.put("155", "Zapadna Europa");
    namesMap.put("419", "Latinska Amerika");
    namesMap.put("AC", "Otok Ascension");
    namesMap.put("AD", "Andora");
    namesMap.put("AE", "Ujedinjeni Arapski Emirati");
    namesMap.put("AF", "Afganistan");
    namesMap.put("AG", "Antigua i Barbuda");
    namesMap.put("AI", "Anguila");
    namesMap.put("AL", "Albanija");
    namesMap.put("AM", "Armenija");
    namesMap.put("AN", "Nizozemski Antili");
    namesMap.put("AQ", "Antarktik");
    namesMap.put("AS", "Američka Samoa");
    namesMap.put("AT", "Austrija");
    namesMap.put("AU", "Australija");
    namesMap.put("AX", "Alandski otoci");
    namesMap.put("AZ", "Azerbajdžan");
    namesMap.put("BA", "Bosna i Hercegovina");
    namesMap.put("BD", "Bangladeš");
    namesMap.put("BE", "Belgija");
    namesMap.put("BG", "Bugarska");
    namesMap.put("BH", "Bahrein");
    namesMap.put("BL", "Sveti Bartolomej");
    namesMap.put("BN", "Brunej");
    namesMap.put("BO", "Bolivija");
    namesMap.put("BS", "Bahami");
    namesMap.put("BT", "Butan");
    namesMap.put("BV", "Otok Bouvet");
    namesMap.put("BW", "Bocvana");
    namesMap.put("BY", "Bjelorusija");
    namesMap.put("CA", "Kanada");
    namesMap.put("CC", "Kokosovi Otoci");
    namesMap.put("CD", "Demokratska Republika Kongo");
    namesMap.put("CF", "Srednjoafrička Republika");
    namesMap.put("CG", "Kongo - Brazzaville");
    namesMap.put("CH", "Švicarska");
    namesMap.put("CI", "Obala Bjelokosti");
    namesMap.put("CK", "Kukovi Otoci");
    namesMap.put("CL", "Čile");
    namesMap.put("CM", "Kamerun");
    namesMap.put("CN", "Kina");
    namesMap.put("CO", "Kolumbija");
    namesMap.put("CP", "Otok Clipperton");
    namesMap.put("CR", "Kostarika");
    namesMap.put("CS", "Srbija i Crna Gora");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Zeleni Rt");
    namesMap.put("CX", "Božićni Otok");
    namesMap.put("CY", "Cipar");
    namesMap.put("CZ", "Češka Republika");
    namesMap.put("DE", "Njemačka");
    namesMap.put("DJ", "Džibuti");
    namesMap.put("DK", "Danska");
    namesMap.put("DM", "Dominika");
    namesMap.put("DO", "Dominikanska Republika");
    namesMap.put("DZ", "Alžir");
    namesMap.put("EA", "Ceuta i Melilla");
    namesMap.put("EC", "Ekvador");
    namesMap.put("EE", "Estonija");
    namesMap.put("EG", "Egipat");
    namesMap.put("EH", "Zapadna Sahara");
    namesMap.put("ER", "Eritreja");
    namesMap.put("ES", "Španjolska");
    namesMap.put("ET", "Etiopija");
    namesMap.put("EU", "Europska Unija");
    namesMap.put("FI", "Finska");
    namesMap.put("FJ", "Fidži");
    namesMap.put("FK", "Falklandski Otoci");
    namesMap.put("FM", "Mikronezija");
    namesMap.put("FO", "Farski Otoci");
    namesMap.put("FR", "Francuska");
    namesMap.put("FX", "Metropolitanska Francuska");
    namesMap.put("GB", "Velika Britanija");
    namesMap.put("GE", "Gruzija");
    namesMap.put("GF", "Francuska Gvajana");
    namesMap.put("GH", "Gana");
    namesMap.put("GL", "Grenland");
    namesMap.put("GM", "Gambija");
    namesMap.put("GN", "Gvineja");
    namesMap.put("GQ", "Ekvatorska Gvineja");
    namesMap.put("GR", "Grčka");
    namesMap.put("GS", "Južna Gruzija i Južni Sendvič Otoci");
    namesMap.put("GT", "Gvatemala");
    namesMap.put("GW", "Gvineja Bisau");
    namesMap.put("GY", "Gvajana");
    namesMap.put("HM", "Otok Heard i Otoci McDonald");
    namesMap.put("HR", "Hrvatska");
    namesMap.put("HU", "Mađarska");
    namesMap.put("IC", "Kanarski Otoci");
    namesMap.put("ID", "Indonezija");
    namesMap.put("IE", "Irska");
    namesMap.put("IL", "Izrael");
    namesMap.put("IM", "Otok Man");
    namesMap.put("IN", "Indija");
    namesMap.put("IO", "Britanski Teritorij Indijskog Oceana");
    namesMap.put("IQ", "Irak");
    namesMap.put("IS", "Island");
    namesMap.put("IT", "Italija");
    namesMap.put("JM", "Jamajka");
    namesMap.put("KE", "Kenija");
    namesMap.put("KG", "Kirgistan");
    namesMap.put("KH", "Kambodža");
    namesMap.put("KM", "Komori");
    namesMap.put("KN", "Sveti Kristofor i Nevis");
    namesMap.put("KP", "Sjeverna Koreja");
    namesMap.put("KR", "Južna Koreja");
    namesMap.put("KW", "Kuvajt");
    namesMap.put("KY", "Kajmanski Otoci");
    namesMap.put("KZ", "Kazakstan");
    namesMap.put("LB", "Libanon");
    namesMap.put("LC", "Sveta Lucija");
    namesMap.put("LI", "Lihtenštajn");
    namesMap.put("LK", "Šri Lanka");
    namesMap.put("LR", "Liberija");
    namesMap.put("LS", "Lesoto");
    namesMap.put("LT", "Litva");
    namesMap.put("LU", "Luksemburg");
    namesMap.put("LV", "Latvija");
    namesMap.put("LY", "Libija");
    namesMap.put("MA", "Maroko");
    namesMap.put("MC", "Monako");
    namesMap.put("MD", "Moldavija");
    namesMap.put("ME", "Crna Gora");
    namesMap.put("MF", "Sveti Martin");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Maršalovi Otoci");
    namesMap.put("MK", "Makedonija");
    namesMap.put("MM", "Mijanma");
    namesMap.put("MN", "Mongolija");
    namesMap.put("MO", "Makao");
    namesMap.put("MP", "Sjeverni Marijanski Otoci");
    namesMap.put("MQ", "Martinik");
    namesMap.put("MR", "Mauritanija");
    namesMap.put("MS", "Montserat");
    namesMap.put("MU", "Mauricijus");
    namesMap.put("MV", "Maldivi");
    namesMap.put("MW", "Malavi");
    namesMap.put("MX", "Meksiko");
    namesMap.put("MY", "Malezija");
    namesMap.put("MZ", "Mozambik");
    namesMap.put("NA", "Namibija");
    namesMap.put("NC", "Nova Kaledonija");
    namesMap.put("NF", "Otok Norfolk");
    namesMap.put("NG", "Nigerija");
    namesMap.put("NI", "Nikaragva");
    namesMap.put("NL", "Nizozemska");
    namesMap.put("NO", "Norveška");
    namesMap.put("NZ", "Novi Zeland");
    namesMap.put("PF", "Francuska Polinezija");
    namesMap.put("PG", "Papua Nova Gvineja");
    namesMap.put("PH", "Filipini");
    namesMap.put("PL", "Poljska");
    namesMap.put("PM", "Sveti Petar i Miguel");
    namesMap.put("PN", "Pitcairn");
    namesMap.put("PR", "Portoriko");
    namesMap.put("PS", "Palestinsko Područje");
    namesMap.put("PY", "Paragvaj");
    namesMap.put("QA", "Katar");
    namesMap.put("QO", "Ostala oceanija");
    namesMap.put("RE", "Reunion");
    namesMap.put("RO", "Rumunjska");
    namesMap.put("RS", "Srbija");
    namesMap.put("RU", "Rusija");
    namesMap.put("RW", "Ruanda");
    namesMap.put("SA", "Saudijska Arabija");
    namesMap.put("SB", "Solomonski Otoci");
    namesMap.put("SC", "Sejšeli");
    namesMap.put("SE", "Švedska");
    namesMap.put("SG", "Singapur");
    namesMap.put("SH", "Sveta Helena");
    namesMap.put("SI", "Slovenija");
    namesMap.put("SJ", "Svalbard i Jan Mayen");
    namesMap.put("SK", "Slovačka");
    namesMap.put("SL", "Sijera Leone");
    namesMap.put("SO", "Somalija");
    namesMap.put("SR", "Surinam");
    namesMap.put("ST", "Sveti Toma i Prinsipe");
    namesMap.put("SY", "Sirija");
    namesMap.put("SZ", "Svazi");
    namesMap.put("TC", "Turkski i Kaikos Otoci");
    namesMap.put("TD", "Čad");
    namesMap.put("TF", "Francuski Južni Teritoriji");
    namesMap.put("TH", "Tajland");
    namesMap.put("TJ", "Tadžikistan");
    namesMap.put("TL", "Istočni Timor");
    namesMap.put("TN", "Tunis");
    namesMap.put("TR", "Turska");
    namesMap.put("TT", "Trinidad i Tobago");
    namesMap.put("TW", "Tajvan");
    namesMap.put("TZ", "Tanzanija");
    namesMap.put("UA", "Ukrajina");
    namesMap.put("UM", "Ujedinjene Države Manjih Pacifičkih Otoka");
    namesMap.put("US", "Sjedinjene Države");
    namesMap.put("UY", "Urugvaj");
    namesMap.put("VA", "Grad Vatikan");
    namesMap.put("VC", "Sveti Vincent i Grenadini");
    namesMap.put("VG", "Britanski Djevičanski Otoci");
    namesMap.put("VI", "Američki Djevičanski Otoci");
    namesMap.put("VN", "Vijetnam");
    namesMap.put("WF", "Wallis i Futuna");
    namesMap.put("YE", "Jemen");
    namesMap.put("YT", "Majote");
    namesMap.put("ZA", "Južnoafrička Republika");
    namesMap.put("ZM", "Zambija");
    namesMap.put("ZW", "Zimbabve");
    namesMap.put("ZZ", "nepoznata ili nevažeća oblast");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Svijet",
        "002": "Afrika",
        "003": "Sjevernoamerički kontinent",
        "005": "Južna Amerika",
        "009": "Oceanija",
        "011": "Zapadna Afrika",
        "013": "Centralna Amerika",
        "014": "Istočna Afrika",
        "015": "Sjeverna Afrika",
        "017": "Središnja Afrika",
        "018": "Južna Afrika",
        "019": "Amerike",
        "021": "Sjeverna Amerika",
        "029": "Karibi",
        "030": "Istočna Azija",
        "034": "Južna Azija",
        "035": "Jugoistočna Azija",
        "039": "Južna Europa",
        "053": "Australija i Novi Zeland",
        "054": "Melanezija",
        "057": "Mikronezki oblast",
        "061": "Polinezija",
        "142": "Azija",
        "143": "Srednja Azija",
        "145": "Zapadna Azija",
        "150": "Europa",
        "151": "Istočna Europa",
        "154": "Sjeverna Europa",
        "155": "Zapadna Europa",
        "419": "Latinska Amerika",
        "AC": "Otok Ascension",
        "AD": "Andora",
        "AE": "Ujedinjeni Arapski Emirati",
        "AF": "Afganistan",
        "AG": "Antigua i Barbuda",
        "AI": "Anguila",
        "AL": "Albanija",
        "AM": "Armenija",
        "AN": "Nizozemski Antili",
        "AQ": "Antarktik",
        "AS": "Američka Samoa",
        "AT": "Austrija",
        "AU": "Australija",
        "AX": "Alandski otoci",
        "AZ": "Azerbajdžan",
        "BA": "Bosna i Hercegovina",
        "BD": "Bangladeš",
        "BE": "Belgija",
        "BG": "Bugarska",
        "BH": "Bahrein",
        "BL": "Sveti Bartolomej",
        "BN": "Brunej",
        "BO": "Bolivija",
        "BS": "Bahami",
        "BT": "Butan",
        "BV": "Otok Bouvet",
        "BW": "Bocvana",
        "BY": "Bjelorusija",
        "CA": "Kanada",
        "CC": "Kokosovi Otoci",
        "CD": "Demokratska Republika Kongo",
        "CF": "Srednjoafrička Republika",
        "CG": "Kongo - Brazzaville",
        "CH": "Švicarska",
        "CI": "Obala Bjelokosti",
        "CK": "Kukovi Otoci",
        "CL": "Čile",
        "CM": "Kamerun",
        "CN": "Kina",
        "CO": "Kolumbija",
        "CP": "Otok Clipperton",
        "CR": "Kostarika",
        "CS": "Srbija i Crna Gora",
        "CU": "Kuba",
        "CV": "Zeleni Rt",
        "CX": "Božićni Otok",
        "CY": "Cipar",
        "CZ": "Češka Republika",
        "DE": "Njemačka",
        "DJ": "Džibuti",
        "DK": "Danska",
        "DM": "Dominika",
        "DO": "Dominikanska Republika",
        "DZ": "Alžir",
        "EA": "Ceuta i Melilla",
        "EC": "Ekvador",
        "EE": "Estonija",
        "EG": "Egipat",
        "EH": "Zapadna Sahara",
        "ER": "Eritreja",
        "ES": "Španjolska",
        "ET": "Etiopija",
        "EU": "Europska Unija",
        "FI": "Finska",
        "FJ": "Fidži",
        "FK": "Falklandski Otoci",
        "FM": "Mikronezija",
        "FO": "Farski Otoci",
        "FR": "Francuska",
        "FX": "Metropolitanska Francuska",
        "GB": "Velika Britanija",
        "GE": "Gruzija",
        "GF": "Francuska Gvajana",
        "GH": "Gana",
        "GL": "Grenland",
        "GM": "Gambija",
        "GN": "Gvineja",
        "GQ": "Ekvatorska Gvineja",
        "GR": "Grčka",
        "GS": "Južna Gruzija i Južni Sendvič Otoci",
        "GT": "Gvatemala",
        "GW": "Gvineja Bisau",
        "GY": "Gvajana",
        "HM": "Otok Heard i Otoci McDonald",
        "HR": "Hrvatska",
        "HU": "Mađarska",
        "IC": "Kanarski Otoci",
        "ID": "Indonezija",
        "IE": "Irska",
        "IL": "Izrael",
        "IM": "Otok Man",
        "IN": "Indija",
        "IO": "Britanski Teritorij Indijskog Oceana",
        "IQ": "Irak",
        "IS": "Island",
        "IT": "Italija",
        "JM": "Jamajka",
        "KE": "Kenija",
        "KG": "Kirgistan",
        "KH": "Kambodža",
        "KM": "Komori",
        "KN": "Sveti Kristofor i Nevis",
        "KP": "Sjeverna Koreja",
        "KR": "Južna Koreja",
        "KW": "Kuvajt",
        "KY": "Kajmanski Otoci",
        "KZ": "Kazakstan",
        "LB": "Libanon",
        "LC": "Sveta Lucija",
        "LI": "Lihtenštajn",
        "LK": "Šri Lanka",
        "LR": "Liberija",
        "LS": "Lesoto",
        "LT": "Litva",
        "LU": "Luksemburg",
        "LV": "Latvija",
        "LY": "Libija",
        "MA": "Maroko",
        "MC": "Monako",
        "MD": "Moldavija",
        "ME": "Crna Gora",
        "MF": "Sveti Martin",
        "MG": "Madagaskar",
        "MH": "Maršalovi Otoci",
        "MK": "Makedonija",
        "MM": "Mijanma",
        "MN": "Mongolija",
        "MO": "Makao",
        "MP": "Sjeverni Marijanski Otoci",
        "MQ": "Martinik",
        "MR": "Mauritanija",
        "MS": "Montserat",
        "MU": "Mauricijus",
        "MV": "Maldivi",
        "MW": "Malavi",
        "MX": "Meksiko",
        "MY": "Malezija",
        "MZ": "Mozambik",
        "NA": "Namibija",
        "NC": "Nova Kaledonija",
        "NF": "Otok Norfolk",
        "NG": "Nigerija",
        "NI": "Nikaragva",
        "NL": "Nizozemska",
        "NO": "Norveška",
        "NZ": "Novi Zeland",
        "PF": "Francuska Polinezija",
        "PG": "Papua Nova Gvineja",
        "PH": "Filipini",
        "PL": "Poljska",
        "PM": "Sveti Petar i Miguel",
        "PN": "Pitcairn",
        "PR": "Portoriko",
        "PS": "Palestinsko Područje",
        "PY": "Paragvaj",
        "QA": "Katar",
        "QO": "Ostala oceanija",
        "RE": "Reunion",
        "RO": "Rumunjska",
        "RS": "Srbija",
        "RU": "Rusija",
        "RW": "Ruanda",
        "SA": "Saudijska Arabija",
        "SB": "Solomonski Otoci",
        "SC": "Sejšeli",
        "SE": "Švedska",
        "SG": "Singapur",
        "SH": "Sveta Helena",
        "SI": "Slovenija",
        "SJ": "Svalbard i Jan Mayen",
        "SK": "Slovačka",
        "SL": "Sijera Leone",
        "SO": "Somalija",
        "SR": "Surinam",
        "ST": "Sveti Toma i Prinsipe",
        "SY": "Sirija",
        "SZ": "Svazi",
        "TC": "Turkski i Kaikos Otoci",
        "TD": "Čad",
        "TF": "Francuski Južni Teritoriji",
        "TH": "Tajland",
        "TJ": "Tadžikistan",
        "TL": "Istočni Timor",
        "TN": "Tunis",
        "TR": "Turska",
        "TT": "Trinidad i Tobago",
        "TW": "Tajvan",
        "TZ": "Tanzanija",
        "UA": "Ukrajina",
        "UM": "Ujedinjene Države Manjih Pacifičkih Otoka",
        "US": "Sjedinjene Države",
        "UY": "Urugvaj",
        "VA": "Grad Vatikan",
        "VC": "Sveti Vincent i Grenadini",
        "VG": "Britanski Djevičanski Otoci",
        "VI": "Američki Djevičanski Otoci",
        "VN": "Vijetnam",
        "WF": "Wallis i Futuna",
        "YE": "Jemen",
        "YT": "Majote",
        "ZA": "Južnoafrička Republika",
        "ZM": "Zambija",
        "ZW": "Zimbabve",
        "ZZ": "nepoznata ili nevažeća oblast"
    };
  }-*/;
}
