/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.helix.HelixException;
import org.apache.helix.HelixProperty;
import org.apache.helix.InstanceType;
import org.apache.helix.PropertyKey;
import org.apache.helix.ZNRecord;

public class Message
extends HelixProperty {
    public static final Comparator<Message> CREATE_TIME_COMPARATOR = new Comparator<Message>(){

        @Override
        public int compare(Message m1, Message m2) {
            return (int)(m1.getCreateTimeStamp() - m2.getCreateTimeStamp());
        }
    };

    public Message(MessageType type, String msgId) {
        this(type.toString(), msgId);
    }

    public Message(String type, String msgId) {
        super(new ZNRecord(msgId));
        this._record.setSimpleField(Attributes.MSG_TYPE.toString(), type);
        this.setMsgId(msgId);
        this.setMsgState(MessageState.NEW);
        this._record.setSimpleField(Attributes.CREATE_TIMESTAMP.toString(), "" + new Date().getTime());
    }

    public Message(ZNRecord record) {
        super(record);
        if (this.getMsgState() == null) {
            this.setMsgState(MessageState.NEW);
        }
        if (this.getCreateTimeStamp() == 0L) {
            this._record.setSimpleField(Attributes.CREATE_TIMESTAMP.toString(), "" + new Date().getTime());
        }
    }

    public void setCreateTimeStamp(long timestamp) {
        this._record.setSimpleField(Attributes.CREATE_TIMESTAMP.toString(), "" + timestamp);
    }

    public Message(ZNRecord record, String id) {
        super(new ZNRecord(record, id));
        this.setMsgId(id);
    }

    public void setMsgSubType(String subType) {
        this._record.setSimpleField(Attributes.MSG_SUBTYPE.toString(), subType);
    }

    public String getMsgSubType() {
        return this._record.getSimpleField(Attributes.MSG_SUBTYPE.toString());
    }

    void setMsgType(MessageType type) {
        this._record.setSimpleField(Attributes.MSG_TYPE.toString(), type.toString());
    }

    public String getMsgType() {
        return this._record.getSimpleField(Attributes.MSG_TYPE.toString());
    }

    public String getTgtSessionId() {
        return this._record.getSimpleField(Attributes.TGT_SESSION_ID.toString());
    }

    public void setTgtSessionId(String tgtSessionId) {
        this._record.setSimpleField(Attributes.TGT_SESSION_ID.toString(), tgtSessionId);
    }

    public String getSrcSessionId() {
        return this._record.getSimpleField(Attributes.SRC_SESSION_ID.toString());
    }

    public void setSrcSessionId(String srcSessionId) {
        this._record.setSimpleField(Attributes.SRC_SESSION_ID.toString(), srcSessionId);
    }

    public String getExecutionSessionId() {
        return this._record.getSimpleField(Attributes.EXE_SESSION_ID.toString());
    }

    public void setExecuteSessionId(String exeSessionId) {
        this._record.setSimpleField(Attributes.EXE_SESSION_ID.toString(), exeSessionId);
    }

    public String getMsgSrc() {
        return this._record.getSimpleField(Attributes.SRC_NAME.toString());
    }

    public void setSrcInstanceType(InstanceType type) {
        this._record.setSimpleField(Attributes.SRC_INSTANCE_TYPE.toString(), type.toString());
    }

    public InstanceType getSrcInstanceType() {
        if (this._record.getSimpleFields().containsKey(Attributes.SRC_INSTANCE_TYPE.toString())) {
            return InstanceType.valueOf(this._record.getSimpleField(Attributes.SRC_INSTANCE_TYPE.toString()));
        }
        return InstanceType.PARTICIPANT;
    }

    public void setSrcName(String msgSrc) {
        this._record.setSimpleField(Attributes.SRC_NAME.toString(), msgSrc);
    }

    public String getTgtName() {
        return this._record.getSimpleField(Attributes.TGT_NAME.toString());
    }

    public void setMsgState(MessageState msgState) {
        this._record.setSimpleField(Attributes.MSG_STATE.toString(), msgState.toString().toLowerCase());
    }

    public MessageState getMsgState() {
        return MessageState.valueOf(this._record.getSimpleField(Attributes.MSG_STATE.toString()).toUpperCase());
    }

    public void setPartitionName(String partitionName) {
        this._record.setSimpleField(Attributes.PARTITION_NAME.toString(), partitionName);
    }

    public String getMsgId() {
        return this._record.getSimpleField(Attributes.MSG_ID.toString());
    }

    public void setMsgId(String msgId) {
        this._record.setSimpleField(Attributes.MSG_ID.toString(), msgId);
    }

    public void setFromState(String state) {
        this._record.setSimpleField(Attributes.FROM_STATE.toString(), state);
    }

    public String getFromState() {
        return this._record.getSimpleField(Attributes.FROM_STATE.toString());
    }

    public void setToState(String state) {
        this._record.setSimpleField(Attributes.TO_STATE.toString(), state);
    }

    public String getToState() {
        return this._record.getSimpleField(Attributes.TO_STATE.toString());
    }

    public void setTgtName(String msgTgt) {
        this._record.setSimpleField(Attributes.TGT_NAME.toString(), msgTgt);
    }

    public Boolean getDebug() {
        return false;
    }

    public Integer getGeneration() {
        return 1;
    }

    public void setResourceName(String resourceName) {
        this._record.setSimpleField(Attributes.RESOURCE_NAME.toString(), resourceName);
    }

    public String getResourceName() {
        return this._record.getSimpleField(Attributes.RESOURCE_NAME.toString());
    }

    public String getPartitionName() {
        return this._record.getSimpleField(Attributes.PARTITION_NAME.toString());
    }

    public String getStateModelDef() {
        return this._record.getSimpleField(Attributes.STATE_MODEL_DEF.toString());
    }

    public void setStateModelDef(String stateModelDefName) {
        this._record.setSimpleField(Attributes.STATE_MODEL_DEF.toString(), stateModelDefName);
    }

    public void setReadTimeStamp(long time) {
        this._record.setSimpleField(Attributes.READ_TIMESTAMP.toString(), "" + time);
    }

    public void setExecuteStartTimeStamp(long time) {
        this._record.setSimpleField(Attributes.EXECUTE_START_TIMESTAMP.toString(), "" + time);
    }

    public long getReadTimeStamp() {
        String timestamp = this._record.getSimpleField(Attributes.READ_TIMESTAMP.toString());
        if (timestamp == null) {
            return 0L;
        }
        try {
            return Long.parseLong(timestamp);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public long getExecuteStartTimeStamp() {
        String timestamp = this._record.getSimpleField(Attributes.EXECUTE_START_TIMESTAMP.toString());
        if (timestamp == null) {
            return 0L;
        }
        try {
            return Long.parseLong(timestamp);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public long getCreateTimeStamp() {
        if (this._record.getSimpleField(Attributes.CREATE_TIMESTAMP.toString()) == null) {
            return 0L;
        }
        try {
            return Long.parseLong(this._record.getSimpleField(Attributes.CREATE_TIMESTAMP.toString()));
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public void setCorrelationId(String correlationId) {
        this._record.setSimpleField(Attributes.CORRELATION_ID.toString(), correlationId);
    }

    public String getCorrelationId() {
        return this._record.getSimpleField(Attributes.CORRELATION_ID.toString());
    }

    public int getExecutionTimeout() {
        if (!this._record.getSimpleFields().containsKey(Attributes.TIMEOUT.toString())) {
            return -1;
        }
        try {
            return Integer.parseInt(this._record.getSimpleField(Attributes.TIMEOUT.toString()));
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public void setExecutionTimeout(int timeout) {
        this._record.setSimpleField(Attributes.TIMEOUT.toString(), "" + timeout);
    }

    public void setRetryCount(int retryCount) {
        this._record.setSimpleField(Attributes.RETRY_COUNT.toString(), "" + retryCount);
    }

    public int getRetryCount() {
        try {
            return Integer.parseInt(this._record.getSimpleField(Attributes.RETRY_COUNT.toString()));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public Map<String, String> getResultMap() {
        return this._record.getMapField(Attributes.MESSAGE_RESULT.toString());
    }

    public void setResultMap(Map<String, String> resultMap) {
        this._record.setMapField(Attributes.MESSAGE_RESULT.toString(), resultMap);
    }

    public String getStateModelFactoryName() {
        return this._record.getSimpleField(Attributes.STATE_MODEL_FACTORY_NAME.toString());
    }

    public void setStateModelFactoryName(String factoryName) {
        this._record.setSimpleField(Attributes.STATE_MODEL_FACTORY_NAME.toString(), factoryName);
    }

    @Override
    public int getBucketSize() {
        String bucketSizeStr = this._record.getSimpleField(Attributes.BUCKET_SIZE.toString());
        int bucketSize = 0;
        if (bucketSizeStr != null) {
            try {
                bucketSize = Integer.parseInt(bucketSizeStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return bucketSize;
    }

    @Override
    public void setBucketSize(int bucketSize) {
        if (bucketSize > 0) {
            this._record.setSimpleField(Attributes.BUCKET_SIZE.toString(), "" + bucketSize);
        }
    }

    public void setAttribute(Attributes attr, String val) {
        this._record.setSimpleField(attr.toString(), val);
    }

    public String getAttribute(Attributes attr) {
        return this._record.getSimpleField(attr.toString());
    }

    public static Message createReplyMessage(Message srcMessage, String instanceName, Map<String, String> taskResultMap) {
        if (srcMessage.getCorrelationId() == null) {
            throw new HelixException("Message " + srcMessage.getMsgId() + " does not contain correlation id");
        }
        Message replyMessage = new Message(MessageType.TASK_REPLY, UUID.randomUUID().toString());
        replyMessage.setCorrelationId(srcMessage.getCorrelationId());
        replyMessage.setResultMap(taskResultMap);
        replyMessage.setTgtSessionId("*");
        replyMessage.setMsgState(MessageState.NEW);
        replyMessage.setSrcName(instanceName);
        if (srcMessage.getSrcInstanceType() == InstanceType.CONTROLLER) {
            replyMessage.setTgtName("Controller");
        } else {
            replyMessage.setTgtName(srcMessage.getMsgSrc());
        }
        return replyMessage;
    }

    public void addPartitionName(String partitionName) {
        List<String> partitionNames;
        if (this._record.getListField(Attributes.PARTITION_NAME.toString()) == null) {
            this._record.setListField(Attributes.PARTITION_NAME.toString(), new ArrayList<String>());
        }
        if (!(partitionNames = this._record.getListField(Attributes.PARTITION_NAME.toString())).contains(partitionName)) {
            partitionNames.add(partitionName);
        }
    }

    public List<String> getPartitionNames() {
        List<String> partitionNames = this._record.getListField(Attributes.PARTITION_NAME.toString());
        if (partitionNames == null) {
            return Collections.emptyList();
        }
        return partitionNames;
    }

    public boolean isControlerMsg() {
        return this.getTgtName().equalsIgnoreCase("controller");
    }

    public PropertyKey getKey(PropertyKey.Builder keyBuilder, String instanceName) {
        if (this.isControlerMsg()) {
            return keyBuilder.controllerMessage(this.getId());
        }
        return keyBuilder.message(instanceName, this.getId());
    }

    private boolean isNullOrEmpty(String data) {
        return data == null || data.length() == 0 || data.trim().length() == 0;
    }

    @Override
    public boolean isValid() {
        if (this.getMsgType().equals(MessageType.STATE_TRANSITION.toString())) {
            boolean isNotValid = this.isNullOrEmpty(this.getTgtName()) || this.isNullOrEmpty(this.getPartitionName()) || this.isNullOrEmpty(this.getResourceName()) || this.isNullOrEmpty(this.getStateModelDef()) || this.isNullOrEmpty(this.getToState()) || this.isNullOrEmpty(this.getStateModelFactoryName()) || this.isNullOrEmpty(this.getFromState());
            return !isNotValid;
        }
        return true;
    }

    public static enum MessageState {
        NEW,
        READ,
        UNPROCESSABLE;

    }

    public static enum Attributes {
        MSG_ID,
        SRC_SESSION_ID,
        TGT_SESSION_ID,
        SRC_NAME,
        TGT_NAME,
        SRC_INSTANCE_TYPE,
        MSG_STATE,
        PARTITION_NAME,
        RESOURCE_NAME,
        FROM_STATE,
        TO_STATE,
        STATE_MODEL_DEF,
        CREATE_TIMESTAMP,
        READ_TIMESTAMP,
        EXECUTE_START_TIMESTAMP,
        MSG_TYPE,
        MSG_SUBTYPE,
        CORRELATION_ID,
        MESSAGE_RESULT,
        EXE_SESSION_ID,
        TIMEOUT,
        RETRY_COUNT,
        STATE_MODEL_FACTORY_NAME,
        BUCKET_SIZE,
        PARENT_MSG_ID,
        INNER_MESSAGE;

    }

    public static enum MessageType {
        STATE_TRANSITION,
        SCHEDULER_MSG,
        USER_DEFINE_MSG,
        CONTROLLER_MSG,
        TASK_REPLY,
        NO_OP,
        PARTICIPANT_ERROR_REPORT;

    }
}

