/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.handler.codec.spdy.SpdySettingsFrame;
import io.netty.util.internal.StringUtil;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class DefaultSpdySettingsFrame
implements SpdySettingsFrame {
    private boolean clear;
    private final Map<Integer, Setting> settingsMap = new TreeMap<Integer, Setting>();

    @Override
    public Set<Integer> getIDs() {
        return this.settingsMap.keySet();
    }

    @Override
    public boolean isSet(int ID) {
        Integer key = new Integer(ID);
        return this.settingsMap.containsKey(key);
    }

    @Override
    public int getValue(int ID) {
        Integer key = new Integer(ID);
        if (this.settingsMap.containsKey(key)) {
            return this.settingsMap.get(key).getValue();
        }
        return -1;
    }

    @Override
    public void setValue(int ID, int value) {
        this.setValue(ID, value, false, false);
    }

    @Override
    public void setValue(int ID, int value, boolean persistValue, boolean persisted) {
        if (ID <= 0 || ID > 0xFFFFFF) {
            throw new IllegalArgumentException("Setting ID is not valid: " + ID);
        }
        Integer key = new Integer(ID);
        if (this.settingsMap.containsKey(key)) {
            Setting setting = this.settingsMap.get(key);
            setting.setValue(value);
            setting.setPersist(persistValue);
            setting.setPersisted(persisted);
        } else {
            this.settingsMap.put(key, new Setting(value, persistValue, persisted));
        }
    }

    @Override
    public void removeValue(int ID) {
        Integer key = new Integer(ID);
        if (this.settingsMap.containsKey(key)) {
            this.settingsMap.remove(key);
        }
    }

    @Override
    public boolean persistValue(int ID) {
        Integer key = new Integer(ID);
        if (this.settingsMap.containsKey(key)) {
            return this.settingsMap.get(key).getPersist();
        }
        return false;
    }

    @Override
    public void setPersistValue(int ID, boolean persistValue) {
        Integer key = new Integer(ID);
        if (this.settingsMap.containsKey(key)) {
            this.settingsMap.get(key).setPersist(persistValue);
        }
    }

    @Override
    public boolean isPersisted(int ID) {
        Integer key = new Integer(ID);
        if (this.settingsMap.containsKey(key)) {
            return this.settingsMap.get(key).getPersisted();
        }
        return false;
    }

    @Override
    public void setPersisted(int ID, boolean persisted) {
        Integer key = new Integer(ID);
        if (this.settingsMap.containsKey(key)) {
            this.settingsMap.get(key).setPersisted(persisted);
        }
    }

    @Override
    public boolean clearPreviouslyPersistedSettings() {
        return this.clear;
    }

    @Override
    public void setClearPreviouslyPersistedSettings(boolean clear) {
        this.clear = clear;
    }

    private Set<Map.Entry<Integer, Setting>> getSettings() {
        return this.settingsMap.entrySet();
    }

    private void appendSettings(StringBuilder buf) {
        for (Map.Entry<Integer, Setting> e : this.getSettings()) {
            Setting setting = e.getValue();
            buf.append("--> ");
            buf.append(e.getKey().toString());
            buf.append(":");
            buf.append(setting.getValue());
            buf.append(" (persist value: ");
            buf.append(setting.getPersist());
            buf.append("; persisted: ");
            buf.append(setting.getPersisted());
            buf.append(')');
            buf.append(StringUtil.NEWLINE);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append(StringUtil.NEWLINE);
        this.appendSettings(buf);
        buf.setLength(buf.length() - StringUtil.NEWLINE.length());
        return buf.toString();
    }

    private static final class Setting {
        private int value;
        private boolean persist;
        private boolean persisted;

        public Setting(int value, boolean persist, boolean persisted) {
            this.value = value;
            this.persist = persist;
            this.persisted = persisted;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public boolean getPersist() {
            return this.persist;
        }

        public void setPersist(boolean persist) {
            this.persist = persist;
        }

        public boolean getPersisted() {
            return this.persisted;
        }

        public void setPersisted(boolean persisted) {
            this.persisted = persisted;
        }
    }
}

