/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.region;

import io.netty.buffer.ChannelBuffers;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureAggregator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.Channels;
import io.netty.channel.MessageEvent;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class ChannelWritableByteChannel
implements WritableByteChannel {
    private boolean closed;
    private final ChannelHandlerContext context;
    private final ChannelFutureAggregator aggregator;
    private final SocketAddress remote;

    public ChannelWritableByteChannel(ChannelHandlerContext context, MessageEvent event) {
        this(context, new ChannelFutureAggregator(event.getFuture()), event.getRemoteAddress());
    }

    public ChannelWritableByteChannel(ChannelHandlerContext context, ChannelFutureAggregator aggregator, SocketAddress remote) {
        this.context = context;
        this.aggregator = aggregator;
        this.remote = remote;
    }

    @Override
    public boolean isOpen() {
        return !this.closed && this.context.getChannel().isOpen();
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int written = src.remaining();
        ChannelFuture future = Channels.future(this.context.getChannel(), true);
        this.aggregator.addFuture(future);
        Channels.write(this.context, future, ChannelBuffers.wrappedBuffer(src), this.remote);
        return written;
    }
}

