/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=21.0
//  number=$Revision: 6546 Google $
//  date=$Date: 2012-02-07 13:32:35 -0500 (Tue, 07 Feb 2012) $
//  type=root


/**
 * Localized names for the "mk" locale.
 */
public class LocalizedNamesImpl_mk extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "BQ",
        "CW",
        "SS",
        "SX",
        "AF",
        "AU",
        "AT",
        "AZ",
        "AX",
        "AL",
        "DZ",
        "AS",
        "UM",
        "AI",
        "AO",
        "AD",
        "AQ",
        "AG",
        "AR",
        "AW",
        "BD",
        "BB",
        "BS",
        "BH",
        "BE",
        "BZ",
        "BY",
        "BJ",
        "BM",
        "CX",
        "BO",
        "BA",
        "BV",
        "BW",
        "BR",
        "CI",
        "VG",
        "IO",
        "BN",
        "BG",
        "BF",
        "BI",
        "BT",
        "VU",
        "VA",
        "GB",
        "VE",
        "VN",
        "WF",
        "GA",
        "GM",
        "GH",
        "GP",
        "GY",
        "GU",
        "GT",
        "GG",
        "GW",
        "GN",
        "DE",
        "GI",
        "GD",
        "GL",
        "GE",
        "GR",
        "DK",
        "VI",
        "DG",
        "DM",
        "DO",
        "EU",
        "EG",
        "EC",
        "GQ",
        "SV",
        "ER",
        "AM",
        "EE",
        "ET",
        "QO",
        "ZM",
        "EH",
        "CV",
        "ZW",
        "IL",
        "IN",
        "ID",
        "IQ",
        "IR",
        "IE",
        "IS",
        "TL",
        "IT",
        "JM",
        "JP",
        "YE",
        "JO",
        "ZA",
        "GS",
        "KR",
        "KZ",
        "KY",
        "KH",
        "CM",
        "CA",
        "IC",
        "QA",
        "KE",
        "CN",
        "CY",
        "KG",
        "KI",
        "CC",
        "CO",
        "KM",
        "CG",
        "CD",
        "CR",
        "CU",
        "KW",
        "CK",
        "LA",
        "LV",
        "LS",
        "LB",
        "LR",
        "LY",
        "LT",
        "LI",
        "LU",
        "MR",
        "MG",
        "YT",
        "MO",
        "MK",
        "MW",
        "MV",
        "MY",
        "ML",
        "MT",
        "MA",
        "MQ",
        "MH",
        "MU",
        "MX",
        "FM",
        "MM",
        "MZ",
        "MD",
        "MC",
        "MN",
        "MS",
        "NA",
        "NR",
        "NP",
        "NE",
        "NG",
        "NU",
        "NI",
        "NC",
        "NZ",
        "NO",
        "NF",
        "AE",
        "OM",
        "AC",
        "CP",
        "IM",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PL",
        "PR",
        "PT",
        "RE",
        "RO",
        "RW",
        "RU",
        "WS",
        "SM",
        "ST",
        "SA",
        "SZ",
        "SJ",
        "SH",
        "LC",
        "KP",
        "MP",
        "SC",
        "SN",
        "BL",
        "VC",
        "KN",
        "MF",
        "PM",
        "EA",
        "SL",
        "SG",
        "SY",
        "SK",
        "SI",
        "US",
        "SB",
        "SO",
        "RS",
        "CS",
        "SD",
        "SR",
        "TW",
        "TH",
        "TZ",
        "TJ",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TV",
        "TN",
        "TC",
        "TM",
        "TR",
        "UG",
        "UZ",
        "UA",
        "HU",
        "UY",
        "FO",
        "PH",
        "FI",
        "FJ",
        "FK",
        "FR",
        "GF",
        "PF",
        "TF",
        "HT",
        "HM",
        "NL",
        "AN",
        "HK",
        "HN",
        "HR",
        "CF",
        "ME",
        "TD",
        "CZ",
        "CL",
        "JE",
        "DJ",
        "CH",
        "SE",
        "ES",
        "LK",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Свет");
    namesMap.put("002", "Африка");
    namesMap.put("003", "Северна Америка");
    namesMap.put("005", "Јужна Америка");
    namesMap.put("009", "Океанија");
    namesMap.put("011", "Западна Африка");
    namesMap.put("013", "Централна Америка");
    namesMap.put("014", "Источна Африка");
    namesMap.put("015", "Северна Африка");
    namesMap.put("017", "Средна Африка");
    namesMap.put("018", "Јужна континентална Африка");
    namesMap.put("019", "Америки");
    namesMap.put("021", "Северна континентална Америка");
    namesMap.put("029", "Кариби");
    namesMap.put("030", "Источна Азија");
    namesMap.put("034", "Јужна Азија");
    namesMap.put("035", "Југоисточна Азија");
    namesMap.put("039", "Јужна Европа");
    namesMap.put("053", "Австралија и Нов Зеланд");
    namesMap.put("054", "Меланезија");
    namesMap.put("057", "Микронезиски регион");
    namesMap.put("061", "Полинезија");
    namesMap.put("142", "Азија");
    namesMap.put("143", "Централна Азија");
    namesMap.put("145", "Западна Азија");
    namesMap.put("150", "Европа");
    namesMap.put("151", "Источна Европа");
    namesMap.put("154", "Северна Европа");
    namesMap.put("155", "Западна Европа");
    namesMap.put("419", "Латинска Америка");
    namesMap.put("AC", "Остров Асенсион");
    namesMap.put("AD", "Андора");
    namesMap.put("AE", "Обединети Арапски Емирати");
    namesMap.put("AF", "Авганистан");
    namesMap.put("AG", "Антигва и Барбуда");
    namesMap.put("AI", "Ангвила");
    namesMap.put("AL", "Албанија");
    namesMap.put("AM", "Ерменија");
    namesMap.put("AN", "Холандски Антили");
    namesMap.put("AO", "Ангола");
    namesMap.put("AQ", "Антарктик");
    namesMap.put("AR", "Аргентина");
    namesMap.put("AS", "Американска Самоа");
    namesMap.put("AT", "Австрија");
    namesMap.put("AU", "Австралија");
    namesMap.put("AW", "Аруба");
    namesMap.put("AX", "Аландски острови");
    namesMap.put("AZ", "Азербејџан");
    namesMap.put("BA", "Босна и Херцеговина");
    namesMap.put("BB", "Барбадос");
    namesMap.put("BD", "Бангладеш");
    namesMap.put("BE", "Белгија");
    namesMap.put("BF", "Буркина Фасо");
    namesMap.put("BG", "Бугарија");
    namesMap.put("BH", "Бахреин");
    namesMap.put("BI", "Бурунди");
    namesMap.put("BJ", "Бенин");
    namesMap.put("BL", "Сент Бартоломеј");
    namesMap.put("BM", "Бермуди");
    namesMap.put("BN", "Брунеи");
    namesMap.put("BO", "Боливија");
    namesMap.put("BR", "Бразил");
    namesMap.put("BS", "Бахами");
    namesMap.put("BT", "Бутан");
    namesMap.put("BV", "Боувитови острови");
    namesMap.put("BW", "Боцвана");
    namesMap.put("BY", "Белорусија");
    namesMap.put("BZ", "Белизе");
    namesMap.put("CA", "Канада");
    namesMap.put("CC", "Кокосови острови");
    namesMap.put("CD", "Конго - Киншаса");
    namesMap.put("CF", "Централна Африканска Република");
    namesMap.put("CG", "Конго - Бразавил");
    namesMap.put("CH", "Швајцарија");
    namesMap.put("CI", "Брегот на Слоновата Коска");
    namesMap.put("CK", "Кукови Острови");
    namesMap.put("CL", "Чиле");
    namesMap.put("CM", "Камерун");
    namesMap.put("CN", "Кина");
    namesMap.put("CO", "Колумбија");
    namesMap.put("CP", "Остров Клипертон");
    namesMap.put("CR", "Костарика");
    namesMap.put("CS", "Србија и Црна Гора");
    namesMap.put("CU", "Куба");
    namesMap.put("CV", "Зеленортски Острови");
    namesMap.put("CX", "Божиќни Острови");
    namesMap.put("CY", "Кипар");
    namesMap.put("CZ", "Чешка Република");
    namesMap.put("DE", "Германија");
    namesMap.put("DG", "Диего Гарсија");
    namesMap.put("DJ", "Џибути");
    namesMap.put("DK", "Данска");
    namesMap.put("DM", "Доминика");
    namesMap.put("DO", "Доминиканска Република");
    namesMap.put("DZ", "Алжир");
    namesMap.put("EA", "Сеута и Мелија");
    namesMap.put("EC", "Еквадор");
    namesMap.put("EE", "Естонија");
    namesMap.put("EG", "Египет");
    namesMap.put("EH", "Западна Сахара");
    namesMap.put("ER", "Еритреја");
    namesMap.put("ES", "Шпанија");
    namesMap.put("ET", "Етиопија");
    namesMap.put("EU", "Европска унија");
    namesMap.put("FI", "Финска");
    namesMap.put("FJ", "Фиџи");
    namesMap.put("FK", "Фолкландски Острови");
    namesMap.put("FM", "Микронезија");
    namesMap.put("FO", "Фарски Острови");
    namesMap.put("FR", "Франција");
    namesMap.put("GA", "Габон");
    namesMap.put("GB", "Велика Британија");
    namesMap.put("GD", "Гренада");
    namesMap.put("GE", "Грузија");
    namesMap.put("GF", "Француска Гвајана");
    namesMap.put("GG", "Гвернзи");
    namesMap.put("GH", "Гана");
    namesMap.put("GI", "Гибралтар");
    namesMap.put("GL", "Гренланд");
    namesMap.put("GM", "Гамбија");
    namesMap.put("GN", "Гвинеја");
    namesMap.put("GP", "Гвадалупе");
    namesMap.put("GQ", "Екваторска Гвинеја");
    namesMap.put("GR", "Грција");
    namesMap.put("GS", "Јужна Грузија и Јужни Сендвич Острови");
    namesMap.put("GT", "Гватемала");
    namesMap.put("GU", "Гвам");
    namesMap.put("GW", "Гвинеа-Биса");
    namesMap.put("GY", "Гвајана");
    namesMap.put("HK", "Хонг Конг");
    namesMap.put("HM", "Хардови острови и Мекдоналд Острови");
    namesMap.put("HN", "Хондурас");
    namesMap.put("HR", "Хрватска");
    namesMap.put("HT", "Хаити");
    namesMap.put("HU", "Унгарија");
    namesMap.put("IC", "Канарски острови");
    namesMap.put("ID", "Индонезија");
    namesMap.put("IE", "Ирска");
    namesMap.put("IL", "Израел");
    namesMap.put("IM", "Островот Ман");
    namesMap.put("IN", "Индија");
    namesMap.put("IO", "Британско Индиско Океанска територија");
    namesMap.put("IQ", "Ирак");
    namesMap.put("IR", "Иран");
    namesMap.put("IS", "Исланд");
    namesMap.put("IT", "Италија");
    namesMap.put("JE", "Џерси");
    namesMap.put("JM", "Јамајка");
    namesMap.put("JO", "Јордан");
    namesMap.put("JP", "Јапонија");
    namesMap.put("KE", "Кенија");
    namesMap.put("KG", "Киргистан");
    namesMap.put("KH", "Камбоџа");
    namesMap.put("KI", "Кирибати");
    namesMap.put("KM", "Коморос");
    namesMap.put("KN", "Сент Кристофер и Невис");
    namesMap.put("KP", "Северна Кореја");
    namesMap.put("KR", "Јужна Кореја");
    namesMap.put("KW", "Кувајт");
    namesMap.put("KY", "Кајмански Острови");
    namesMap.put("KZ", "Казахстан");
    namesMap.put("LA", "Лаос");
    namesMap.put("LB", "Либан");
    namesMap.put("LC", "Света Лучија");
    namesMap.put("LI", "Лихтенштајн");
    namesMap.put("LK", "Шри Ланка");
    namesMap.put("LR", "Либерија");
    namesMap.put("LS", "Лесото");
    namesMap.put("LT", "Литванија");
    namesMap.put("LU", "Луксембург");
    namesMap.put("LV", "Латвија");
    namesMap.put("LY", "Либија");
    namesMap.put("MA", "Мароко");
    namesMap.put("MC", "Монако");
    namesMap.put("MD", "Молдавија");
    namesMap.put("ME", "Црна Гора");
    namesMap.put("MF", "Сент Мартин");
    namesMap.put("MG", "Мадагаскар");
    namesMap.put("MH", "Маршалови острови");
    namesMap.put("MK", "Македонија");
    namesMap.put("ML", "Мали");
    namesMap.put("MM", "Мјанмар [Бурма]");
    namesMap.put("MN", "Монголија");
    namesMap.put("MO", "Макао");
    namesMap.put("MP", "Северни Маријанини Острови");
    namesMap.put("MQ", "Мартиник");
    namesMap.put("MR", "Мавританија");
    namesMap.put("MS", "Монсерат");
    namesMap.put("MT", "Малта");
    namesMap.put("MU", "Маурициус");
    namesMap.put("MV", "Малдиви");
    namesMap.put("MW", "Малави");
    namesMap.put("MX", "Мексико");
    namesMap.put("MY", "Малезија");
    namesMap.put("MZ", "Мозамбик");
    namesMap.put("NA", "Намибија");
    namesMap.put("NC", "Нова Каледонија");
    namesMap.put("NE", "Нигер");
    namesMap.put("NF", "Нофролк Остров");
    namesMap.put("NG", "Нигерија");
    namesMap.put("NI", "Никарагва");
    namesMap.put("NL", "Холандија");
    namesMap.put("NO", "Норвешка");
    namesMap.put("NP", "Непал");
    namesMap.put("NR", "Науру");
    namesMap.put("NU", "Ние");
    namesMap.put("NZ", "Нов Зеланд");
    namesMap.put("OM", "Оман");
    namesMap.put("PA", "Панама");
    namesMap.put("PE", "Перу");
    namesMap.put("PF", "Француска Полинезија");
    namesMap.put("PG", "Папуа Нова Гвинеја");
    namesMap.put("PH", "Филипини");
    namesMap.put("PK", "Пакистан");
    namesMap.put("PL", "Полска");
    namesMap.put("PM", "Сент Пјер и Микелан");
    namesMap.put("PN", "Питкарн");
    namesMap.put("PR", "Порторико");
    namesMap.put("PS", "Палестински територии");
    namesMap.put("PT", "Португалија");
    namesMap.put("PW", "Палау");
    namesMap.put("PY", "Парагвај");
    namesMap.put("QA", "Катар");
    namesMap.put("QO", "Зависни земји во Океанија");
    namesMap.put("RE", "Ријунион");
    namesMap.put("RO", "Романија");
    namesMap.put("RS", "Србија");
    namesMap.put("RU", "Русија");
    namesMap.put("RW", "Руанда");
    namesMap.put("SA", "Саудиска Арабија");
    namesMap.put("SB", "Соломоновите Острови");
    namesMap.put("SC", "Сејшели");
    namesMap.put("SD", "Судан");
    namesMap.put("SE", "Шведска");
    namesMap.put("SG", "Сингапур");
    namesMap.put("SH", "Света Елена");
    namesMap.put("SI", "Словенија");
    namesMap.put("SJ", "Свалбард и Жан Мејен");
    namesMap.put("SK", "Словачка");
    namesMap.put("SL", "Сиера Леоне");
    namesMap.put("SM", "Сан Марино");
    namesMap.put("SN", "Сенегал");
    namesMap.put("SO", "Сомалија");
    namesMap.put("SR", "Суринам");
    namesMap.put("ST", "Сао Томе и Принчипе");
    namesMap.put("SV", "Ел Салвадор");
    namesMap.put("SY", "Сирија");
    namesMap.put("SZ", "Свазиленд");
    namesMap.put("TA", "Тристан да Куња");
    namesMap.put("TC", "Турк и Каикос Острови");
    namesMap.put("TD", "Чад");
    namesMap.put("TF", "Француски Јужни територии");
    namesMap.put("TG", "Того");
    namesMap.put("TH", "Тајланд");
    namesMap.put("TJ", "Таџикистан");
    namesMap.put("TK", "Токелау");
    namesMap.put("TL", "Источен Тимор [Тимор Лесте]");
    namesMap.put("TM", "Туркменистан");
    namesMap.put("TN", "Тунис");
    namesMap.put("TO", "Тонга");
    namesMap.put("TR", "Турција");
    namesMap.put("TT", "Тринидад и Тобаго");
    namesMap.put("TV", "Тувалу");
    namesMap.put("TW", "Тајван");
    namesMap.put("TZ", "Танзанија");
    namesMap.put("UA", "Украина");
    namesMap.put("UG", "Уганда");
    namesMap.put("UM", "Американски територии во Пацификот");
    namesMap.put("US", "Соединети Американски Држави");
    namesMap.put("UY", "Уругвај");
    namesMap.put("UZ", "Узбекистан");
    namesMap.put("VA", "Ватикан");
    namesMap.put("VC", "Сент Винсент и Гренадините");
    namesMap.put("VE", "Венецуела");
    namesMap.put("VG", "Британски Девствени Острови");
    namesMap.put("VI", "Девствени Острови на САД");
    namesMap.put("VN", "Виетнам");
    namesMap.put("VU", "Ванату");
    namesMap.put("WF", "Волис и Футуна острови");
    namesMap.put("WS", "Самоа");
    namesMap.put("YE", "Јемен");
    namesMap.put("YT", "Мајоте");
    namesMap.put("ZA", "Јужна Африка");
    namesMap.put("ZM", "Замбија");
    namesMap.put("ZW", "Зимбабве");
    namesMap.put("ZZ", "Непознат регион");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Свет",
        "002": "Африка",
        "003": "Северна Америка",
        "005": "Јужна Америка",
        "009": "Океанија",
        "011": "Западна Африка",
        "013": "Централна Америка",
        "014": "Источна Африка",
        "015": "Северна Африка",
        "017": "Средна Африка",
        "018": "Јужна континентална Африка",
        "019": "Америки",
        "021": "Северна континентална Америка",
        "029": "Кариби",
        "030": "Источна Азија",
        "034": "Јужна Азија",
        "035": "Југоисточна Азија",
        "039": "Јужна Европа",
        "053": "Австралија и Нов Зеланд",
        "054": "Меланезија",
        "057": "Микронезиски регион",
        "061": "Полинезија",
        "142": "Азија",
        "143": "Централна Азија",
        "145": "Западна Азија",
        "150": "Европа",
        "151": "Источна Европа",
        "154": "Северна Европа",
        "155": "Западна Европа",
        "419": "Латинска Америка",
        "AC": "Остров Асенсион",
        "AD": "Андора",
        "AE": "Обединети Арапски Емирати",
        "AF": "Авганистан",
        "AG": "Антигва и Барбуда",
        "AI": "Ангвила",
        "AL": "Албанија",
        "AM": "Ерменија",
        "AN": "Холандски Антили",
        "AO": "Ангола",
        "AQ": "Антарктик",
        "AR": "Аргентина",
        "AS": "Американска Самоа",
        "AT": "Австрија",
        "AU": "Австралија",
        "AW": "Аруба",
        "AX": "Аландски острови",
        "AZ": "Азербејџан",
        "BA": "Босна и Херцеговина",
        "BB": "Барбадос",
        "BD": "Бангладеш",
        "BE": "Белгија",
        "BF": "Буркина Фасо",
        "BG": "Бугарија",
        "BH": "Бахреин",
        "BI": "Бурунди",
        "BJ": "Бенин",
        "BL": "Сент Бартоломеј",
        "BM": "Бермуди",
        "BN": "Брунеи",
        "BO": "Боливија",
        "BR": "Бразил",
        "BS": "Бахами",
        "BT": "Бутан",
        "BV": "Боувитови острови",
        "BW": "Боцвана",
        "BY": "Белорусија",
        "BZ": "Белизе",
        "CA": "Канада",
        "CC": "Кокосови острови",
        "CD": "Конго - Киншаса",
        "CF": "Централна Африканска Република",
        "CG": "Конго - Бразавил",
        "CH": "Швајцарија",
        "CI": "Брегот на Слоновата Коска",
        "CK": "Кукови Острови",
        "CL": "Чиле",
        "CM": "Камерун",
        "CN": "Кина",
        "CO": "Колумбија",
        "CP": "Остров Клипертон",
        "CR": "Костарика",
        "CS": "Србија и Црна Гора",
        "CU": "Куба",
        "CV": "Зеленортски Острови",
        "CX": "Божиќни Острови",
        "CY": "Кипар",
        "CZ": "Чешка Република",
        "DE": "Германија",
        "DG": "Диего Гарсија",
        "DJ": "Џибути",
        "DK": "Данска",
        "DM": "Доминика",
        "DO": "Доминиканска Република",
        "DZ": "Алжир",
        "EA": "Сеута и Мелија",
        "EC": "Еквадор",
        "EE": "Естонија",
        "EG": "Египет",
        "EH": "Западна Сахара",
        "ER": "Еритреја",
        "ES": "Шпанија",
        "ET": "Етиопија",
        "EU": "Европска унија",
        "FI": "Финска",
        "FJ": "Фиџи",
        "FK": "Фолкландски Острови",
        "FM": "Микронезија",
        "FO": "Фарски Острови",
        "FR": "Франција",
        "GA": "Габон",
        "GB": "Велика Британија",
        "GD": "Гренада",
        "GE": "Грузија",
        "GF": "Француска Гвајана",
        "GG": "Гвернзи",
        "GH": "Гана",
        "GI": "Гибралтар",
        "GL": "Гренланд",
        "GM": "Гамбија",
        "GN": "Гвинеја",
        "GP": "Гвадалупе",
        "GQ": "Екваторска Гвинеја",
        "GR": "Грција",
        "GS": "Јужна Грузија и Јужни Сендвич Острови",
        "GT": "Гватемала",
        "GU": "Гвам",
        "GW": "Гвинеа-Биса",
        "GY": "Гвајана",
        "HK": "Хонг Конг",
        "HM": "Хардови острови и Мекдоналд Острови",
        "HN": "Хондурас",
        "HR": "Хрватска",
        "HT": "Хаити",
        "HU": "Унгарија",
        "IC": "Канарски острови",
        "ID": "Индонезија",
        "IE": "Ирска",
        "IL": "Израел",
        "IM": "Островот Ман",
        "IN": "Индија",
        "IO": "Британско Индиско Океанска територија",
        "IQ": "Ирак",
        "IR": "Иран",
        "IS": "Исланд",
        "IT": "Италија",
        "JE": "Џерси",
        "JM": "Јамајка",
        "JO": "Јордан",
        "JP": "Јапонија",
        "KE": "Кенија",
        "KG": "Киргистан",
        "KH": "Камбоџа",
        "KI": "Кирибати",
        "KM": "Коморос",
        "KN": "Сент Кристофер и Невис",
        "KP": "Северна Кореја",
        "KR": "Јужна Кореја",
        "KW": "Кувајт",
        "KY": "Кајмански Острови",
        "KZ": "Казахстан",
        "LA": "Лаос",
        "LB": "Либан",
        "LC": "Света Лучија",
        "LI": "Лихтенштајн",
        "LK": "Шри Ланка",
        "LR": "Либерија",
        "LS": "Лесото",
        "LT": "Литванија",
        "LU": "Луксембург",
        "LV": "Латвија",
        "LY": "Либија",
        "MA": "Мароко",
        "MC": "Монако",
        "MD": "Молдавија",
        "ME": "Црна Гора",
        "MF": "Сент Мартин",
        "MG": "Мадагаскар",
        "MH": "Маршалови острови",
        "MK": "Македонија",
        "ML": "Мали",
        "MM": "Мјанмар [Бурма]",
        "MN": "Монголија",
        "MO": "Макао",
        "MP": "Северни Маријанини Острови",
        "MQ": "Мартиник",
        "MR": "Мавританија",
        "MS": "Монсерат",
        "MT": "Малта",
        "MU": "Маурициус",
        "MV": "Малдиви",
        "MW": "Малави",
        "MX": "Мексико",
        "MY": "Малезија",
        "MZ": "Мозамбик",
        "NA": "Намибија",
        "NC": "Нова Каледонија",
        "NE": "Нигер",
        "NF": "Нофролк Остров",
        "NG": "Нигерија",
        "NI": "Никарагва",
        "NL": "Холандија",
        "NO": "Норвешка",
        "NP": "Непал",
        "NR": "Науру",
        "NU": "Ние",
        "NZ": "Нов Зеланд",
        "OM": "Оман",
        "PA": "Панама",
        "PE": "Перу",
        "PF": "Француска Полинезија",
        "PG": "Папуа Нова Гвинеја",
        "PH": "Филипини",
        "PK": "Пакистан",
        "PL": "Полска",
        "PM": "Сент Пјер и Микелан",
        "PN": "Питкарн",
        "PR": "Порторико",
        "PS": "Палестински територии",
        "PT": "Португалија",
        "PW": "Палау",
        "PY": "Парагвај",
        "QA": "Катар",
        "QO": "Зависни земји во Океанија",
        "RE": "Ријунион",
        "RO": "Романија",
        "RS": "Србија",
        "RU": "Русија",
        "RW": "Руанда",
        "SA": "Саудиска Арабија",
        "SB": "Соломоновите Острови",
        "SC": "Сејшели",
        "SD": "Судан",
        "SE": "Шведска",
        "SG": "Сингапур",
        "SH": "Света Елена",
        "SI": "Словенија",
        "SJ": "Свалбард и Жан Мејен",
        "SK": "Словачка",
        "SL": "Сиера Леоне",
        "SM": "Сан Марино",
        "SN": "Сенегал",
        "SO": "Сомалија",
        "SR": "Суринам",
        "ST": "Сао Томе и Принчипе",
        "SV": "Ел Салвадор",
        "SY": "Сирија",
        "SZ": "Свазиленд",
        "TA": "Тристан да Куња",
        "TC": "Турк и Каикос Острови",
        "TD": "Чад",
        "TF": "Француски Јужни територии",
        "TG": "Того",
        "TH": "Тајланд",
        "TJ": "Таџикистан",
        "TK": "Токелау",
        "TL": "Источен Тимор [Тимор Лесте]",
        "TM": "Туркменистан",
        "TN": "Тунис",
        "TO": "Тонга",
        "TR": "Турција",
        "TT": "Тринидад и Тобаго",
        "TV": "Тувалу",
        "TW": "Тајван",
        "TZ": "Танзанија",
        "UA": "Украина",
        "UG": "Уганда",
        "UM": "Американски територии во Пацификот",
        "US": "Соединети Американски Држави",
        "UY": "Уругвај",
        "UZ": "Узбекистан",
        "VA": "Ватикан",
        "VC": "Сент Винсент и Гренадините",
        "VE": "Венецуела",
        "VG": "Британски Девствени Острови",
        "VI": "Девствени Острови на САД",
        "VN": "Виетнам",
        "VU": "Ванату",
        "WF": "Волис и Футуна острови",
        "WS": "Самоа",
        "YE": "Јемен",
        "YT": "Мајоте",
        "ZA": "Јужна Африка",
        "ZM": "Замбија",
        "ZW": "Зимбабве",
        "ZZ": "Непознат регион"
    };
  }-*/;
}
