/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.server.auth.source;

import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import org.uberfire.commons.validation.Preconditions;
import org.uberfire.security.Role;
import org.uberfire.security.SecurityContext;
import org.uberfire.security.auth.AuthenticationSource;
import org.uberfire.security.auth.Credential;
import org.uberfire.security.auth.Principal;
import org.uberfire.security.auth.RoleProvider;
import org.uberfire.security.impl.RoleImpl;
import org.uberfire.security.impl.auth.UserNameCredential;

public class JACCAuthenticationSource
implements AuthenticationSource,
RoleProvider {
    public static final String DEFAULT_ROLE_PRINCIPLE_NAME = "Roles";
    private String rolePrincipleName = "Roles";

    public void initialize(Map<String, ?> options) {
        if (options.containsKey("org.uf.context.roles")) {
            this.rolePrincipleName = (String)options.get("org.uf.context.roles");
        }
    }

    public boolean supportsCredential(Credential credential) {
        if (credential == null) {
            return false;
        }
        return credential instanceof UserNameCredential;
    }

    public boolean authenticate(Credential credential, SecurityContext securityContext) {
        UserNameCredential userNameCredential = (UserNameCredential)Preconditions.checkInstanceOf((String)"credential", (Object)credential, UserNameCredential.class);
        try {
            Set<java.security.Principal> principals;
            Subject subject = (Subject)PolicyContext.getContext((String)"javax.security.auth.Subject.container");
            if (subject != null && (principals = subject.getPrincipals()) != null) {
                for (java.security.Principal p : principals) {
                    if (!p.getName().equals(userNameCredential.getUserName())) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public List<Role> loadRoles(Principal principal) {
        ArrayList<RoleImpl> roles;
        block4: {
            roles = null;
            try {
                Set<java.security.Principal> principals;
                Subject subject = (Subject)PolicyContext.getContext((String)"javax.security.auth.Subject.container");
                if (subject == null || (principals = subject.getPrincipals()) == null) break block4;
                roles = new ArrayList<RoleImpl>();
                for (java.security.Principal p : principals) {
                    if (!(p instanceof Group) || !this.rolePrincipleName.equalsIgnoreCase(p.getName())) continue;
                    Enumeration groups = ((Group)p).members();
                    while (groups.hasMoreElements()) {
                        java.security.Principal groupPrincipal = (java.security.Principal)groups.nextElement();
                        roles.add(new RoleImpl(groupPrincipal.getName()));
                    }
                    break;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return roles;
    }
}

