/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server;

import java.util.Iterator;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.uberfire.backend.server.util.TextUtil;
import org.uberfire.io.FileSystemType;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class UserServicesBackendImpl {
    @Inject
    @Named(value="configIO")
    private IOService ioService;
    private FileSystem bootstrapRoot = null;

    @PostConstruct
    public void init() {
        Iterator fsIterator = this.ioService.getFileSystems((FileSystemType)FileSystemType.Bootstrap.BOOTSTRAP_INSTANCE).iterator();
        if (fsIterator.hasNext()) {
            this.bootstrapRoot = (FileSystem)fsIterator.next();
        }
    }

    public Path buildPath(String _userName, String serviceType, String relativePath) {
        String resultUserName = TextUtil.normalizeUserName(_userName);
        if (relativePath != null && !"".equals(relativePath)) {
            return this.bootstrapRoot.getPath(resultUserName + "-uf-user", new String[]{serviceType, relativePath});
        }
        return this.bootstrapRoot.getPath(resultUserName + "-uf-user", new String[]{serviceType});
    }
}

