/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.alerts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.helix.alerts.Operator;
import org.apache.helix.alerts.Tuple;

public class MultiplyOperator
extends Operator {
    public MultiplyOperator() {
        this.minInputTupleLists = 1;
        this.maxInputTupleLists = Integer.MAX_VALUE;
        this.inputOutputTupleListsCountsEqual = false;
        this.numOutputTupleLists = 1;
    }

    public List<Iterator<Tuple<String>>> singleSetToIter(ArrayList<Tuple<String>> input) {
        ArrayList<Iterator<Tuple<String>>> out = new ArrayList<Iterator<Tuple<String>>>();
        out.add(input.iterator());
        return out;
    }

    @Override
    public List<Iterator<Tuple<String>>> execute(List<Iterator<Tuple<String>>> input) {
        ArrayList<Tuple<String>> output = new ArrayList<Tuple<String>>();
        if (input == null || input.size() == 0) {
            return this.singleSetToIter(output);
        }
        while (true) {
            Tuple<String> rowProduct = null;
            for (Iterator<Tuple<String>> it : input) {
                if (!it.hasNext()) {
                    return this.singleSetToIter(output);
                }
                rowProduct = this.multiplyTuples(rowProduct, it.next());
            }
            output.add(rowProduct);
        }
    }
}

