/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixProperty;
import org.apache.helix.PropertyKey;
import org.apache.helix.PropertyType;
import org.apache.helix.ZNRecord;
import org.apache.helix.alerts.AlertProcessor;
import org.apache.helix.alerts.AlertValueAndStatus;
import org.apache.helix.alerts.AlertsHolder;
import org.apache.helix.alerts.StatsHolder;
import org.apache.helix.alerts.Tuple;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.pipeline.StageContext;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.HealthDataCache;
import org.apache.helix.healthcheck.StatHealthReportProvider;
import org.apache.helix.manager.zk.DefaultParticipantErrorMessageHandlerFactory;
import org.apache.helix.model.AlertHistory;
import org.apache.helix.model.HealthStat;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.PersistentStats;
import org.apache.helix.monitoring.mbeans.ClusterAlertMBeanCollection;
import org.apache.log4j.Logger;

public class StatsAggregationStage
extends AbstractBaseStage {
    public static final int ALERT_HISTORY_SIZE = 30;
    private static final Logger logger = Logger.getLogger((String)StatsAggregationStage.class.getName());
    StatsHolder _statsHolder = null;
    AlertsHolder _alertsHolder = null;
    Map<String, Map<String, AlertValueAndStatus>> _alertStatus;
    Map<String, Tuple<String>> _statStatus;
    ClusterAlertMBeanCollection _alertBeanCollection = new ClusterAlertMBeanCollection();
    Map<String, String> _alertActionTaken = new HashMap<String, String>();
    public final String PARTICIPANT_STAT_REPORT_NAME = "ParticipantStats";
    public final String ESPRESSO_STAT_REPORT_NAME = "RestQueryStats";
    public final String REPORT_NAME = "AggStats";
    public StatHealthReportProvider _aggStatsProvider;

    public Map<String, Map<String, AlertValueAndStatus>> getAlertStatus() {
        return this._alertStatus;
    }

    public Map<String, Tuple<String>> getStatStatus() {
        return this._statStatus;
    }

    public void persistAggStats(HelixManager manager) {
        PropertyKey.Builder keyBuilder;
        HelixDataAccessor accessor;
        boolean retVal;
        Map<String, String> report = this._aggStatsProvider.getRecentHealthReport();
        Map<String, Map<String, String>> partitionReport = this._aggStatsProvider.getRecentPartitionHealthReport();
        ZNRecord record = new ZNRecord(this._aggStatsProvider.getReportName());
        if (report != null) {
            record.setSimpleFields(report);
        }
        if (partitionReport != null) {
            record.setMapFields(partitionReport);
        }
        if (!(retVal = (accessor = manager.getHelixDataAccessor()).setProperty((keyBuilder = accessor.keyBuilder()).persistantStat(), new PersistentStats(record)))) {
            logger.error((Object)"attempt to persist derived stats failed");
        }
    }

    @Override
    public void init(StageContext context) {
    }

    public String getAgeStatName(String instance) {
        return instance + "." + "reportingage";
    }

    public void reportAgeStat(LiveInstance instance, long modifiedTime, long currTime) {
        String statName = this.getAgeStatName(instance.getInstanceName());
        long age = (currTime - modifiedTime) / 1000L;
        HashMap<String, String> ageStatMap = new HashMap<String, String>();
        ageStatMap.put("TimeStamp", String.valueOf(currTime));
        ageStatMap.put("value", String.valueOf(age));
        this._statsHolder.applyStat(statName, ageStatMap);
    }

    @Override
    public void process(ClusterEvent event) throws Exception {
        long startTime = System.currentTimeMillis();
        HelixManager manager = (HelixManager)event.getAttribute("helixmanager");
        HealthDataCache cache = (HealthDataCache)event.getAttribute("HealthDataCache");
        if (manager == null || cache == null) {
            throw new StageException("helixmanager|HealthDataCache attribute value is null");
        }
        if (this._alertsHolder == null) {
            this._statsHolder = new StatsHolder(manager, cache);
            this._alertsHolder = new AlertsHolder(manager, cache, this._statsHolder);
        } else {
            this._statsHolder.updateCache(cache);
            this._alertsHolder.updateCache(cache);
        }
        if (this._statsHolder.getStatsList().size() == 0) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"stat holder is empty");
            }
            return;
        }
        Map<String, LiveInstance> liveInstances = cache.getLiveInstances();
        long currTime = System.currentTimeMillis();
        long readInstancesStart = System.currentTimeMillis();
        for (LiveInstance instance : liveInstances.values()) {
            String instanceName = instance.getInstanceName();
            logger.debug((Object)("instanceName: " + instanceName));
            Map<String, HealthStat> stats = cache.getHealthStats(instanceName);
            long modTime = -1L;
            boolean reportedAge = false;
            for (HealthStat participantStat : stats.values()) {
                if (participantStat != null && !reportedAge) {
                    modTime = participantStat.getLastModifiedTimeStamp();
                    this.reportAgeStat(instance, modTime, currTime);
                    reportedAge = true;
                }
                if (participantStat == null) continue;
                Map<String, Map<String, String>> statMap = participantStat.getHealthFields(instanceName);
                for (String key : statMap.keySet()) {
                    this._statsHolder.applyStat(key, statMap.get(key));
                }
            }
        }
        this._statsHolder.persistStats();
        logger.info((Object)("Done processing stats: " + (System.currentTimeMillis() - readInstancesStart)));
        this._statStatus = this._statsHolder.getStatsMap();
        for (String statKey : this._statStatus.keySet()) {
            logger.debug((Object)("Stat key, value: " + statKey + ": " + this._statStatus.get(statKey)));
        }
        long alertExecuteStartTime = System.currentTimeMillis();
        this._alertStatus = AlertProcessor.executeAllAlerts(this._alertsHolder.getAlertList(), this._statsHolder.getStatsList());
        logger.info((Object)("done executing alerts: " + (System.currentTimeMillis() - alertExecuteStartTime)));
        for (String originAlertName : this._alertStatus.keySet()) {
            this._alertBeanCollection.setAlerts(originAlertName, this._alertStatus.get(originAlertName), manager.getClusterName());
        }
        this.executeAlertActions(manager);
        this.updateAlertHistory(manager);
        long writeAlertStartTime = System.currentTimeMillis();
        this._alertsHolder.addAlertStatusSet(this._alertStatus);
        logger.info((Object)("done writing alerts: " + (System.currentTimeMillis() - writeAlertStartTime)));
        long logAlertStartTime = System.currentTimeMillis();
        for (String alertOuterKey : this._alertStatus.keySet()) {
            logger.debug((Object)("Alert Outer Key: " + alertOuterKey));
            Map<String, AlertValueAndStatus> alertInnerMap = this._alertStatus.get(alertOuterKey);
            if (alertInnerMap == null) {
                logger.debug((Object)(alertOuterKey + " has no alerts to report."));
                continue;
            }
            for (String alertInnerKey : alertInnerMap.keySet()) {
                logger.debug((Object)("  " + alertInnerKey + " value: " + alertInnerMap.get(alertInnerKey).getValue() + ", status: " + alertInnerMap.get(alertInnerKey).isFired()));
            }
        }
        logger.info((Object)("done logging alerts: " + (System.currentTimeMillis() - logAlertStartTime)));
        long processLatency = System.currentTimeMillis() - startTime;
        this.addLatencyToMonitor(event, processLatency);
        logger.info((Object)("process end: " + processLatency));
    }

    void executeAlertActions(HelixManager manager) {
        this._alertActionTaken.clear();
        for (String originAlertName : this._alertStatus.keySet()) {
            Map<String, String> alertFields = this._alertsHolder.getAlertsMap().get(originAlertName);
            if (alertFields == null || !alertFields.containsKey("ACTION")) continue;
            String actionValue = alertFields.get("ACTION");
            Map<String, AlertValueAndStatus> alertResultMap = this._alertStatus.get(originAlertName);
            if (alertResultMap == null) {
                logger.info((Object)("Alert " + originAlertName + " does not have alert status map"));
                continue;
            }
            for (String actualStatName : alertResultMap.keySet()) {
                if (!alertResultMap.get(actualStatName).isFired()) continue;
                logger.warn((Object)("Alert " + originAlertName + " action " + actionValue + " is triggered by " + actualStatName));
                this._alertActionTaken.put(actualStatName, actionValue);
                this.executeAlertAction(actualStatName, actionValue, manager);
            }
        }
    }

    void executeAlertAction(String actualStatName, String actionValue, HelixManager manager) {
        if (actionValue.equals(DefaultParticipantErrorMessageHandlerFactory.ActionOnError.DISABLE_INSTANCE.toString())) {
            String instanceName = StatsAggregationStage.parseInstanceName(actualStatName, manager);
            if (instanceName != null) {
                logger.info((Object)("Disabling instance " + instanceName));
                manager.getClusterManagmentTool().enableInstance(manager.getClusterName(), instanceName, false);
            }
        } else if (actionValue.equals(DefaultParticipantErrorMessageHandlerFactory.ActionOnError.DISABLE_PARTITION.toString())) {
            String instanceName = StatsAggregationStage.parseInstanceName(actualStatName, manager);
            String resourceName = StatsAggregationStage.parseResourceName(actualStatName, manager);
            String partitionName = StatsAggregationStage.parsePartitionName(actualStatName, manager);
            if (instanceName != null && resourceName != null && partitionName != null) {
                logger.info((Object)("Disabling partition " + partitionName + " instanceName " + instanceName));
                manager.getClusterManagmentTool().enablePartition(false, manager.getClusterName(), instanceName, resourceName, Arrays.asList(partitionName));
            }
        } else if (actionValue.equals(DefaultParticipantErrorMessageHandlerFactory.ActionOnError.DISABLE_RESOURCE.toString())) {
            String instanceName = StatsAggregationStage.parseInstanceName(actualStatName, manager);
            String resourceName = StatsAggregationStage.parseResourceName(actualStatName, manager);
            logger.info((Object)("Disabling resource " + resourceName + " instanceName " + instanceName + " not implemented"));
        }
    }

    public static String parseResourceName(String actualStatName, HelixManager manager) {
        HelixDataAccessor accessor = manager.getHelixDataAccessor();
        PropertyKey.Builder kb = accessor.keyBuilder();
        List idealStates = accessor.getChildValues(kb.idealStates());
        for (IdealState idealState : idealStates) {
            String resourceName = idealState.getResourceName();
            if (!actualStatName.contains("=" + resourceName + ".") && !actualStatName.contains("=" + resourceName + ";")) continue;
            return resourceName;
        }
        return null;
    }

    public static String parsePartitionName(String actualStatName, HelixManager manager) {
        String partitionKey;
        String resourceName = StatsAggregationStage.parseResourceName(actualStatName, manager);
        if (resourceName != null && actualStatName.contains(partitionKey = "=" + resourceName + "_")) {
            int pos = actualStatName.indexOf(partitionKey);
            int nextDotPos = actualStatName.indexOf(46, pos + partitionKey.length());
            int nextCommaPos = actualStatName.indexOf(59, pos + partitionKey.length());
            if (nextCommaPos > 0 && nextCommaPos < nextDotPos) {
                nextDotPos = nextCommaPos;
            }
            String partitionName = actualStatName.substring(pos + 1, nextDotPos);
            return partitionName;
        }
        return null;
    }

    public static String parseInstanceName(String actualStatName, HelixManager manager) {
        HelixDataAccessor accessor = manager.getHelixDataAccessor();
        PropertyKey.Builder kb = accessor.keyBuilder();
        List liveInstances = accessor.getChildValues(kb.liveInstances());
        for (LiveInstance instance : liveInstances) {
            String instanceName = instance.getInstanceName();
            if (!actualStatName.startsWith(instanceName)) continue;
            return instanceName;
        }
        return null;
    }

    void updateAlertHistory(HelixManager manager) {
        this._alertBeanCollection.refreshAlertDelta(manager.getClusterName());
        Map<String, String> delta = this._alertBeanCollection.getRecentAlertDelta();
        if (delta.size() > 0) {
            delta.putAll(this._alertActionTaken);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-hh:mm:ss:SSS");
            String date = dateFormat.format(new Date());
            HelixDataAccessor accessor = manager.getHelixDataAccessor();
            PropertyKey.Builder keyBuilder = accessor.keyBuilder();
            Object property = accessor.getProperty(keyBuilder.alertHistory());
            ZNRecord alertFiredHistory = property == null ? new ZNRecord(PropertyType.ALERT_HISTORY.toString()) : ((HelixProperty)property).getRecord();
            while (alertFiredHistory.getMapFields().size() >= 30) {
                String firstKey = (String)alertFiredHistory.getMapFields().keySet().toArray()[0];
                alertFiredHistory.getMapFields().remove(firstKey);
            }
            alertFiredHistory.setMapField(date, delta);
            accessor.setProperty(keyBuilder.alertHistory(), new AlertHistory(alertFiredHistory));
            this._alertBeanCollection.setAlertHistory(alertFiredHistory);
        }
    }

    public ClusterAlertMBeanCollection getClusterAlertMBeanCollection() {
        return this._alertBeanCollection;
    }
}

