/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.healthcheck;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.helix.healthcheck.HealthReportProvider;
import org.apache.helix.healthcheck.Stat;
import org.apache.log4j.Logger;

public class StatHealthReportProvider
extends HealthReportProvider {
    private static final Logger _logger = Logger.getLogger(StatHealthReportProvider.class);
    public static final String REPORT_NAME = "ParticipantStats";
    public String _reportName = "ParticipantStats";
    public static final String STAT_VALUE = "value";
    public static final String TIMESTAMP = "timestamp";
    public int readLatencyCount = 0;
    public double readLatencySum = 0.0;
    public int requestCount = 0;
    private final ConcurrentHashMap<String, String> _statsToValues = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> _statsToTimestamps = new ConcurrentHashMap();

    @Override
    public Map<String, String> getRecentHealthReport() {
        return null;
    }

    @Override
    public Map<String, Map<String, String>> getRecentPartitionHealthReport() {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        for (String stat : this._statsToValues.keySet()) {
            HashMap<String, String> currStat = new HashMap<String, String>();
            currStat.put(TIMESTAMP, this._statsToTimestamps.get(stat));
            currStat.put(STAT_VALUE, this._statsToValues.get(stat));
            result.put(stat, currStat);
        }
        return result;
    }

    public boolean contains(Stat inStat) {
        return this._statsToValues.containsKey(inStat);
    }

    public Set<String> keySet() {
        return this._statsToValues.keySet();
    }

    public String getStatValue(Stat inStat) {
        return this._statsToValues.get(inStat);
    }

    public long getStatTimestamp(Stat inStat) {
        return Long.parseLong(this._statsToTimestamps.get(inStat));
    }

    public void writeStat(String statName, String val, String timestamp) {
        this._statsToValues.put(statName, val);
        this._statsToTimestamps.put(statName, timestamp);
    }

    public void incrementStat(String statName, String timestamp) {
        String val = this._statsToValues.get(statName);
        val = val == null ? "0" : String.valueOf(Double.parseDouble(val) + 1.0);
        this.writeStat(statName, val, timestamp);
    }

    public int size() {
        return this._statsToValues.size();
    }

    @Override
    public void resetStats() {
        this._statsToValues.clear();
        this._statsToTimestamps.clear();
    }

    public void setReportName(String name) {
        this._reportName = name;
    }

    @Override
    public String getReportName() {
        return this._reportName;
    }
}

