/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import java.util.TimerTask;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.PropertyKey;
import org.apache.helix.PropertyType;
import org.apache.helix.ZNRecord;
import org.apache.helix.manager.zk.ZNRecordSerializer;
import org.apache.helix.manager.zk.ZkClient;
import org.apache.helix.util.HelixUtil;
import org.apache.log4j.Logger;
import org.apache.zookeeper.data.Stat;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;

public class ZKPathDataDumpTask
extends TimerTask {
    static Logger logger = Logger.getLogger(ZKPathDataDumpTask.class);
    private final int _thresholdNoChangeInMs;
    private final HelixManager _manager;
    private final ZkClient _zkClient;

    public ZKPathDataDumpTask(HelixManager manager, ZkClient zkClient, int thresholdNoChangeInMs) {
        this._manager = manager;
        this._zkClient = zkClient;
        logger.info((Object)("Scannning cluster statusUpdate " + manager.getClusterName() + " thresholdNoChangeInMs: " + thresholdNoChangeInMs));
        this._thresholdNoChangeInMs = thresholdNoChangeInMs;
    }

    @Override
    public void run() {
        logger.info((Object)"Scannning status updates ...");
        try {
            HelixDataAccessor accessor = this._manager.getHelixDataAccessor();
            PropertyKey.Builder keyBuilder = accessor.keyBuilder();
            List<String> instances = accessor.getChildNames(keyBuilder.instanceConfigs());
            for (String instanceName : instances) {
                this.scanPath(HelixUtil.getInstancePropertyPath(this._manager.getClusterName(), instanceName, PropertyType.STATUSUPDATES), this._thresholdNoChangeInMs);
                this.scanPath(HelixUtil.getInstancePropertyPath(this._manager.getClusterName(), instanceName, PropertyType.ERRORS), this._thresholdNoChangeInMs * 3);
            }
            this.scanPath(HelixUtil.getControllerPropertyPath(this._manager.getClusterName(), PropertyType.STATUSUPDATES_CONTROLLER), this._thresholdNoChangeInMs);
            this.scanPath(HelixUtil.getControllerPropertyPath(this._manager.getClusterName(), PropertyType.ERRORS_CONTROLLER), this._thresholdNoChangeInMs * 3);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    void scanPath(String path, int thresholdNoChangeInMs) {
        logger.info((Object)("Scannning path " + path));
        List subPaths = this._zkClient.getChildren(path);
        for (String subPath : subPaths) {
            try {
                String nextPath = path + "/" + subPath;
                List subSubPaths = this._zkClient.getChildren(nextPath);
                for (String subsubPath : subSubPaths) {
                    try {
                        this.checkAndDump(nextPath + "/" + subsubPath, thresholdNoChangeInMs);
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    void checkAndDump(String path, int thresholdNoChangeInMs) {
        List subPaths = this._zkClient.getChildren(path);
        if (subPaths.size() == 0) {
            subPaths.add("");
        }
        for (String subPath : subPaths) {
            long timeDiff;
            String fullPath = subPath.length() > 0 ? path + "/" + subPath : path;
            Stat pathStat = this._zkClient.getStat(fullPath);
            long lastModifiedTimeInMs = pathStat.getMtime();
            long nowInMs = new Date().getTime();
            if (nowInMs <= lastModifiedTimeInMs || (timeDiff = nowInMs - lastModifiedTimeInMs) <= (long)thresholdNoChangeInMs) continue;
            logger.info((Object)("Dumping status update path " + fullPath + " " + timeDiff + "MS has passed"));
            this._zkClient.setZkSerializer(new ZNRecordSerializer());
            ZNRecord record = (ZNRecord)this._zkClient.readData(fullPath);
            ObjectMapper mapper = new ObjectMapper();
            SerializationConfig serializationConfig = mapper.getSerializationConfig();
            serializationConfig.set(SerializationConfig.Feature.INDENT_OUTPUT, true);
            StringWriter sw = new StringWriter();
            try {
                mapper.writeValue((Writer)sw, (Object)record);
                logger.info((Object)sw.toString());
            }
            catch (Exception e) {
                logger.warn((Object)"Exception during serialization in ZKPathDataDumpTask.checkAndDump. This can mostly be ignored", (Throwable)e);
            }
            this._zkClient.deleteRecursive(fullPath);
        }
    }
}

