/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.discard;

import io.netty.buffer.ChannelBuffer;
import io.netty.channel.ChannelEvent;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelStateEvent;
import io.netty.channel.ExceptionEvent;
import io.netty.channel.MessageEvent;
import io.netty.channel.SimpleChannelUpstreamHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DiscardServerHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger logger = Logger.getLogger(DiscardServerHandler.class.getName());
    private long transferredBytes;

    public long getTransferredBytes() {
        return this.transferredBytes;
    }

    @Override
    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (e instanceof ChannelStateEvent) {
            logger.info(e.toString());
        }
        super.handleUpstream(ctx, e);
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        this.transferredBytes += (long)((ChannelBuffer)e.getMessage()).readableBytes();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        logger.log(Level.WARNING, "Unexpected exception from downstream.", e.getCause());
        e.getChannel().close();
    }
}

