/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.spdy.SpdyCodecUtil;
import io.netty.handler.codec.spdy.SpdyHeaderBlock;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class SpdyHeaders {
    private static final int BUCKET_SIZE = 17;
    private final Entry[] entries = new Entry[17];
    private final Entry head;

    public static String getHeader(SpdyHeaderBlock block, String name) {
        return block.getHeader(name);
    }

    public static String getHeader(SpdyHeaderBlock block, String name, String defaultValue) {
        String value = block.getHeader(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static void setHeader(SpdyHeaderBlock block, String name, Object value) {
        block.setHeader(name, value);
    }

    public static void setHeader(SpdyHeaderBlock block, String name, Iterable<?> values) {
        block.setHeader(name, values);
    }

    public static void addHeader(SpdyHeaderBlock block, String name, Object value) {
        block.addHeader(name, value);
    }

    public static void removeMethod(SpdyHeaderBlock block) {
        block.removeHeader("method");
    }

    public static HttpMethod getMethod(SpdyHeaderBlock block) {
        try {
            return HttpMethod.valueOf(block.getHeader("method"));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setMethod(SpdyHeaderBlock block, HttpMethod method) {
        block.setHeader("method", method.getName());
    }

    public static void removeScheme(SpdyHeaderBlock block) {
        block.removeHeader("scheme");
    }

    public static String getScheme(SpdyHeaderBlock block) {
        return block.getHeader("scheme");
    }

    public static void setScheme(SpdyHeaderBlock block, String value) {
        block.setHeader("scheme", value);
    }

    public static void removeStatus(SpdyHeaderBlock block) {
        block.removeHeader("status");
    }

    public static HttpResponseStatus getStatus(SpdyHeaderBlock block) {
        try {
            String status = block.getHeader("status");
            int space = status.indexOf(32);
            if (space == -1) {
                return HttpResponseStatus.valueOf(Integer.parseInt(status));
            }
            int code = Integer.parseInt(status.substring(0, space));
            String reasonPhrase = status.substring(space + 1);
            HttpResponseStatus responseStatus = HttpResponseStatus.valueOf(code);
            if (responseStatus.getReasonPhrase().equals(responseStatus)) {
                return responseStatus;
            }
            return new HttpResponseStatus(code, reasonPhrase);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setStatus(SpdyHeaderBlock block, HttpResponseStatus status) {
        block.setHeader("status", status.toString());
    }

    public static void removeUrl(SpdyHeaderBlock block) {
        block.removeHeader("url");
    }

    public static String getUrl(SpdyHeaderBlock block) {
        return block.getHeader("url");
    }

    public static void setUrl(SpdyHeaderBlock block, String value) {
        block.setHeader("url", value);
    }

    public static void removeVersion(SpdyHeaderBlock block) {
        block.removeHeader("version");
    }

    public static HttpVersion getVersion(SpdyHeaderBlock block) {
        try {
            return HttpVersion.valueOf(block.getHeader("version"));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setVersion(SpdyHeaderBlock block, HttpVersion version) {
        block.setHeader("version", version.getText());
    }

    private static int hash(String name) {
        int h = 0;
        for (int i = name.length() - 1; i >= 0; --i) {
            char c = name.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            h = 31 * h + c;
        }
        if (h > 0) {
            return h;
        }
        if (h == Integer.MIN_VALUE) {
            return Integer.MAX_VALUE;
        }
        return -h;
    }

    private static boolean eq(String name1, String name2) {
        int nameLen = name1.length();
        if (nameLen != name2.length()) {
            return false;
        }
        for (int i = nameLen - 1; i >= 0; --i) {
            char c2;
            char c1 = name1.charAt(i);
            if (c1 == (c2 = name2.charAt(i))) continue;
            if (c1 >= 'A' && c1 <= 'Z') {
                c1 = (char)(c1 + 32);
            }
            if (c2 >= 'A' && c2 <= 'Z') {
                c2 = (char)(c2 + 32);
            }
            if (c1 == c2) continue;
            return false;
        }
        return true;
    }

    private static int index(int hash) {
        return hash % 17;
    }

    SpdyHeaders() {
        this.head.before = this.head.after = (this.head = new Entry(-1, null, null));
    }

    void addHeader(String name, Object value) {
        String lowerCaseName = name.toLowerCase();
        SpdyCodecUtil.validateHeaderName(lowerCaseName);
        String strVal = SpdyHeaders.toString(value);
        SpdyCodecUtil.validateHeaderValue(strVal);
        int h = SpdyHeaders.hash(lowerCaseName);
        int i = SpdyHeaders.index(h);
        this.addHeader0(h, i, lowerCaseName, strVal);
    }

    private void addHeader0(int h, int i, String name, String value) {
        Entry newEntry;
        Entry e = this.entries[i];
        this.entries[i] = newEntry = new Entry(h, name, value);
        newEntry.next = e;
        newEntry.addBefore(this.head);
    }

    void removeHeader(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        String lowerCaseName = name.toLowerCase();
        int h = SpdyHeaders.hash(lowerCaseName);
        int i = SpdyHeaders.index(h);
        this.removeHeader0(h, i, lowerCaseName);
    }

    private void removeHeader0(int h, int i, String name) {
        Entry next;
        Entry e = this.entries[i];
        if (e == null) {
            return;
        }
        while (e.hash == h && SpdyHeaders.eq(name, e.key)) {
            e.remove();
            next = e.next;
            if (next != null) {
                this.entries[i] = next;
                e = next;
                continue;
            }
            this.entries[i] = null;
            return;
        }
        while ((next = e.next) != null) {
            if (next.hash == h && SpdyHeaders.eq(name, next.key)) {
                e.next = next.next;
                next.remove();
                continue;
            }
            e = next;
        }
    }

    void setHeader(String name, Object value) {
        String lowerCaseName = name.toLowerCase();
        SpdyCodecUtil.validateHeaderName(lowerCaseName);
        String strVal = SpdyHeaders.toString(value);
        SpdyCodecUtil.validateHeaderValue(strVal);
        int h = SpdyHeaders.hash(lowerCaseName);
        int i = SpdyHeaders.index(h);
        this.removeHeader0(h, i, lowerCaseName);
        this.addHeader0(h, i, lowerCaseName, strVal);
    }

    void setHeader(String name, Iterable<?> values) {
        if (values == null) {
            throw new NullPointerException("values");
        }
        String lowerCaseName = name.toLowerCase();
        SpdyCodecUtil.validateHeaderName(lowerCaseName);
        int h = SpdyHeaders.hash(lowerCaseName);
        int i = SpdyHeaders.index(h);
        this.removeHeader0(h, i, lowerCaseName);
        for (Object v : values) {
            if (v == null) break;
            String strVal = SpdyHeaders.toString(v);
            SpdyCodecUtil.validateHeaderValue(strVal);
            this.addHeader0(h, i, lowerCaseName, strVal);
        }
    }

    void clearHeaders() {
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i] = null;
        }
        this.head.before = this.head.after = this.head;
    }

    String getHeader(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        int h = SpdyHeaders.hash(name);
        int i = SpdyHeaders.index(h);
        Entry e = this.entries[i];
        while (e != null) {
            if (e.hash == h && SpdyHeaders.eq(name, e.key)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    List<String> getHeaders(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        LinkedList<String> values = new LinkedList<String>();
        int h = SpdyHeaders.hash(name);
        int i = SpdyHeaders.index(h);
        Entry e = this.entries[i];
        while (e != null) {
            if (e.hash == h && SpdyHeaders.eq(name, e.key)) {
                values.addFirst(e.value);
            }
            e = e.next;
        }
        return values;
    }

    List<Map.Entry<String, String>> getHeaders() {
        LinkedList<Map.Entry<String, String>> all = new LinkedList<Map.Entry<String, String>>();
        Entry e = this.head.after;
        while (e != this.head) {
            all.add(e);
            e = e.after;
        }
        return all;
    }

    boolean containsHeader(String name) {
        return this.getHeader(name) != null;
    }

    Set<String> getHeaderNames() {
        TreeSet<String> names = new TreeSet<String>();
        Entry e = this.head.after;
        while (e != this.head) {
            names.add(e.key);
            e = e.after;
        }
        return names;
    }

    private static String toString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    private static final class Entry
    implements Map.Entry<String, String> {
        final int hash;
        final String key;
        String value;
        Entry next;
        Entry before;
        Entry after;

        Entry(int hash, String key, String value) {
            this.hash = hash;
            this.key = key;
            this.value = value;
        }

        void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
        }

        void addBefore(Entry e) {
            this.after = e;
            this.before = e.before;
            this.before.after = this;
            this.after.before = this;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String setValue(String value) {
            if (value == null) {
                throw new NullPointerException("value");
            }
            SpdyCodecUtil.validateHeaderValue(value);
            String oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    public static final class HttpNames {
        public static final String METHOD = "method";
        public static final String SCHEME = "scheme";
        public static final String STATUS = "status";
        public static final String URL = "url";
        public static final String VERSION = "version";

        private HttpNames() {
        }
    }
}

