/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.Channels;
import io.netty.channel.WriteCompletionEvent;

public class DefaultWriteCompletionEvent
implements WriteCompletionEvent {
    private final Channel channel;
    private final long writtenAmount;

    public DefaultWriteCompletionEvent(Channel channel, long writtenAmount) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        if (writtenAmount <= 0L) {
            throw new IllegalArgumentException("writtenAmount must be a positive integer: " + writtenAmount);
        }
        this.channel = channel;
        this.writtenAmount = writtenAmount;
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public ChannelFuture getFuture() {
        return Channels.succeededFuture(this.getChannel());
    }

    @Override
    public long getWrittenAmount() {
        return this.writtenAmount;
    }

    public String toString() {
        String channelString = this.getChannel().toString();
        StringBuilder buf = new StringBuilder(channelString.length() + 32);
        buf.append(channelString);
        buf.append(" WRITTEN_AMOUNT: ");
        buf.append(this.getWrittenAmount());
        return buf.toString();
    }
}

