/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.nio;

import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelSink;
import io.netty.channel.Channels;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.AbstractNioChannel;
import io.netty.channel.socket.nio.DefaultNioDatagramChannelConfig;
import io.netty.channel.socket.nio.NioDatagramChannelConfig;
import io.netty.channel.socket.nio.NioDatagramWorker;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;

final class NioDatagramChannel
extends AbstractNioChannel<java.nio.channels.DatagramChannel>
implements DatagramChannel {
    private final NioDatagramChannelConfig config;

    static NioDatagramChannel create(ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, NioDatagramWorker worker) {
        NioDatagramChannel instance = new NioDatagramChannel(factory, pipeline, sink, worker);
        Channels.fireChannelOpen(instance);
        return instance;
    }

    private NioDatagramChannel(ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, NioDatagramWorker worker) {
        super(null, factory, pipeline, sink, worker, NioDatagramChannel.openNonBlockingChannel());
        this.config = new DefaultNioDatagramChannelConfig(((java.nio.channels.DatagramChannel)this.channel).socket());
    }

    private static java.nio.channels.DatagramChannel openNonBlockingChannel() {
        try {
            java.nio.channels.DatagramChannel channel = java.nio.channels.DatagramChannel.open();
            channel.configureBlocking(false);
            return channel;
        }
        catch (IOException e) {
            throw new ChannelException("Failed to open a DatagramChannel.", e);
        }
    }

    @Override
    public boolean isBound() {
        return this.isOpen() && ((java.nio.channels.DatagramChannel)this.channel).socket().isBound();
    }

    @Override
    public boolean isConnected() {
        return ((java.nio.channels.DatagramChannel)this.channel).isConnected();
    }

    @Override
    protected boolean setClosed() {
        return super.setClosed();
    }

    @Override
    public NioDatagramChannelConfig getConfig() {
        return this.config;
    }

    java.nio.channels.DatagramChannel getDatagramChannel() {
        return (java.nio.channels.DatagramChannel)this.channel;
    }

    @Override
    public void joinGroup(InetAddress multicastAddress) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void joinGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void leaveGroup(InetAddress multicastAddress) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void leaveGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface) {
        throw new UnsupportedOperationException();
    }

    @Override
    InetSocketAddress getLocalSocketAddress() throws Exception {
        return (InetSocketAddress)((java.nio.channels.DatagramChannel)this.channel).socket().getLocalSocketAddress();
    }

    @Override
    InetSocketAddress getRemoteSocketAddress() throws Exception {
        return (InetSocketAddress)((java.nio.channels.DatagramChannel)this.channel).socket().getRemoteSocketAddress();
    }
}

