/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.util;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.uberfire.backend.vfs.FileSystem;
import org.uberfire.backend.vfs.FileSystemFactory;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.java.nio.file.Path;

public final class Paths {
    private static Map<org.uberfire.java.nio.file.FileSystem, FileSystem> cache = new HashMap<org.uberfire.java.nio.file.FileSystem, FileSystem>();

    public static org.uberfire.backend.vfs.Path convert(Path path) {
        if (path == null) {
            return null;
        }
        if (path.getFileName() == null) {
            return PathFactory.newPath((FileSystem)Paths.convert(path.getFileSystem()), (String)"/", (String)path.toUri().toString());
        }
        return PathFactory.newPath((FileSystem)Paths.convert(path.getFileSystem()), (String)path.getFileName().toString(), (String)path.toUri().toString());
    }

    public static Path convert(org.uberfire.backend.vfs.Path path) {
        if (path == null) {
            return null;
        }
        try {
            return org.uberfire.java.nio.file.Paths.get((URI)URI.create(path.toURI()));
        }
        catch (IllegalArgumentException e) {
            try {
                return org.uberfire.java.nio.file.Paths.get((URI)URI.create(URIUtil.encodePath((String)path.toURI())));
            }
            catch (URIException ex) {
                return null;
            }
        }
    }

    public static FileSystem convert(org.uberfire.java.nio.file.FileSystem fs) {
        if (!cache.containsKey(fs)) {
            HashMap<String, String> roots = new HashMap<String, String>();
            for (Path root : fs.getRootDirectories()) {
                roots.put(root.toUri().toString(), root.getFileName() == null ? "/" : root.getFileName().toString());
            }
            cache.put(fs, FileSystemFactory.newFS(roots, (Set)fs.supportedFileAttributeViews()));
        }
        return cache.get(fs);
    }
}

