/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.test;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.test.TestEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.UnsafeUriCharactersEncoder;

public class TestComponent
extends DefaultComponent {
    @Override
    public Endpoint createEndpoint(String uri) throws Exception {
        ObjectHelper.notNull(this.getCamelContext(), "camelContext");
        URI u = new URI(UnsafeUriCharactersEncoder.encode(uri));
        String path = u.getSchemeSpecificPart();
        if (path.startsWith("//")) {
            path = path.substring(2);
        }
        return this.createEndpoint(uri, path, new HashMap<String, Object>());
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Long timeout = this.getAndRemoveParameter(parameters, "timeout", Long.class);
        Endpoint endpoint = CamelContextHelper.getMandatoryEndpoint(this.getCamelContext(), remaining);
        TestEndpoint answer = new TestEndpoint(uri, this, endpoint);
        if (timeout != null) {
            answer.setTimeout(timeout);
        }
        return answer;
    }
}

