/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.stream;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StreamCache;
import org.apache.camel.converter.stream.CachedOutputStream;
import org.apache.camel.converter.stream.ReaderCache;
import org.apache.camel.util.IOHelper;

public final class StreamSourceCache
extends StreamSource
implements StreamCache {
    private final InputStream stream;
    private final StreamCache streamCache;
    private final ReaderCache readCache;

    public StreamSourceCache(StreamSource source, Exchange exchange) throws IOException {
        if (source.getInputStream() != null) {
            CachedOutputStream cos = new CachedOutputStream(exchange);
            IOHelper.copyAndCloseInput(source.getInputStream(), cos);
            this.streamCache = cos.newStreamCache();
            this.readCache = null;
            this.setSystemId(source.getSystemId());
            this.stream = (InputStream)((Object)this.streamCache);
        } else if (source.getReader() != null) {
            String data = exchange.getContext().getTypeConverter().convertTo(String.class, exchange, source.getReader());
            this.readCache = new ReaderCache(data);
            this.streamCache = null;
            this.setReader(this.readCache);
            this.stream = new ByteArrayInputStream(data.getBytes());
        } else {
            this.streamCache = null;
            this.readCache = null;
            this.stream = null;
        }
    }

    @Override
    public void reset() {
        if (this.streamCache != null) {
            this.streamCache.reset();
        }
        if (this.readCache != null) {
            this.readCache.reset();
        }
        if (this.stream != null) {
            try {
                this.stream.reset();
            }
            catch (IOException e) {
                throw new RuntimeCamelException(e);
            }
        }
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        if (this.streamCache != null) {
            this.streamCache.writeTo(os);
        } else if (this.readCache != null) {
            this.readCache.writeTo(os);
        }
    }

    @Override
    public boolean inMemory() {
        if (this.streamCache != null) {
            return this.streamCache.inMemory();
        }
        if (this.readCache != null) {
            return this.readCache.inMemory();
        }
        return true;
    }

    @Override
    public long length() {
        if (this.streamCache != null) {
            return this.streamCache.length();
        }
        if (this.readCache != null) {
            return this.readCache.length();
        }
        return 0L;
    }

    @Override
    public InputStream getInputStream() {
        return this.stream;
    }

    @Override
    public void setInputStream(InputStream inputStream) {
    }
}

