/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.Partition;

public class CurrentStateOutput {
    private final Map<String, Map<Partition, Map<String, String>>> _currentStateMap = new HashMap<String, Map<Partition, Map<String, String>>>();
    private final Map<String, Map<Partition, Map<String, String>>> _pendingStateMap = new HashMap<String, Map<Partition, Map<String, String>>>();
    private final Map<String, String> _resourceStateModelMap = new HashMap<String, String>();
    private final Map<String, CurrentState> _curStateMetaMap = new HashMap<String, CurrentState>();

    public void setResourceStateModelDef(String resourceName, String stateModelDefName) {
        this._resourceStateModelMap.put(resourceName, stateModelDefName);
    }

    public String getResourceStateModelDef(String resourceName) {
        return this._resourceStateModelMap.get(resourceName);
    }

    public void setBucketSize(String resource, int bucketSize) {
        CurrentState curStateMeta = this._curStateMetaMap.get(resource);
        if (curStateMeta == null) {
            curStateMeta = new CurrentState(resource);
            this._curStateMetaMap.put(resource, curStateMeta);
        }
        curStateMeta.setBucketSize(bucketSize);
    }

    public int getBucketSize(String resource) {
        int bucketSize = 0;
        CurrentState curStateMeta = this._curStateMetaMap.get(resource);
        if (curStateMeta != null) {
            bucketSize = curStateMeta.getBucketSize();
        }
        return bucketSize;
    }

    public void setCurrentState(String resourceName, Partition partition, String instanceName, String state) {
        if (!this._currentStateMap.containsKey(resourceName)) {
            this._currentStateMap.put(resourceName, new HashMap());
        }
        if (!this._currentStateMap.get(resourceName).containsKey(partition)) {
            this._currentStateMap.get(resourceName).put(partition, new HashMap());
        }
        this._currentStateMap.get(resourceName).get(partition).put(instanceName, state);
    }

    public void setPendingState(String resourceName, Partition partition, String instanceName, String state) {
        if (!this._pendingStateMap.containsKey(resourceName)) {
            this._pendingStateMap.put(resourceName, new HashMap());
        }
        if (!this._pendingStateMap.get(resourceName).containsKey(partition)) {
            this._pendingStateMap.get(resourceName).put(partition, new HashMap());
        }
        this._pendingStateMap.get(resourceName).get(partition).put(instanceName, state);
    }

    public String getCurrentState(String resourceName, Partition partition, String instanceName) {
        Map<String, String> instanceStateMap;
        Map<Partition, Map<String, String>> map = this._currentStateMap.get(resourceName);
        if (map != null && (instanceStateMap = map.get(partition)) != null) {
            return instanceStateMap.get(instanceName);
        }
        return null;
    }

    public String getPendingState(String resourceName, Partition partition, String instanceName) {
        Map<String, String> instanceStateMap;
        Map<Partition, Map<String, String>> map = this._pendingStateMap.get(resourceName);
        if (map != null && (instanceStateMap = map.get(partition)) != null) {
            return instanceStateMap.get(instanceName);
        }
        return null;
    }

    public Map<String, String> getCurrentStateMap(String resourceName, Partition partition) {
        Map<Partition, Map<String, String>> map;
        if (this._currentStateMap.containsKey(resourceName) && (map = this._currentStateMap.get(resourceName)).containsKey(partition)) {
            return map.get(partition);
        }
        return Collections.emptyMap();
    }

    public Map<String, String> getPendingStateMap(String resourceName, Partition partition) {
        Map<Partition, Map<String, String>> map;
        if (this._pendingStateMap.containsKey(resourceName) && (map = this._pendingStateMap.get(resourceName)).containsKey(partition)) {
            return map.get(partition);
        }
        return Collections.emptyMap();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("current state= ").append(this._currentStateMap);
        sb.append(", pending state= ").append(this._pendingStateMap);
        return sb.toString();
    }
}

