/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.iostream;

import io.netty.buffer.ChannelBuffer;
import io.netty.buffer.ChannelBuffers;
import io.netty.channel.AbstractChannelSink;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelEvent;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelState;
import io.netty.channel.ChannelStateEvent;
import io.netty.channel.Channels;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.MessageEvent;
import io.netty.channel.iostream.IoStreamAddress;
import io.netty.channel.iostream.IoStreamChannel;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.concurrent.ExecutorService;

public class IoStreamChannelSink
extends AbstractChannelSink {
    private final ExecutorService executorService;
    private IoStreamChannel channel;
    private IoStreamAddress remoteAddress;
    private OutputStream outputStream;
    private PushbackInputStream inputStream;
    private final ChannelConfig config = new DefaultChannelConfig();

    public IoStreamChannelSink(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public boolean isConnected() {
        return this.inputStream != null && this.outputStream != null;
    }

    public IoStreamAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public boolean isBound() {
        return false;
    }

    public ChannelConfig getConfig() {
        return this.config;
    }

    public void setChannel(IoStreamChannel channel) {
        this.channel = channel;
    }

    @Override
    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) throws Exception {
        ChannelFuture future = e.getFuture();
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent stateEvent = (ChannelStateEvent)e;
            ChannelState state = stateEvent.getState();
            Object value = stateEvent.getValue();
            switch (state) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(value)) break;
                    this.outputStream = null;
                    this.inputStream = null;
                    ((IoStreamChannel)e.getChannel()).doSetClosed();
                    break;
                }
                case BOUND: {
                    throw new UnsupportedOperationException();
                }
                case CONNECTED: {
                    if (value == null) break;
                    this.remoteAddress = (IoStreamAddress)value;
                    this.outputStream = this.remoteAddress.getOutputStream();
                    this.inputStream = new PushbackInputStream(this.remoteAddress.getInputStream());
                    this.executorService.execute(new ReadRunnable(this));
                    future.setSuccess();
                    break;
                }
                case INTEREST_OPS: {
                    throw new UnsupportedOperationException();
                }
            }
        } else if (e instanceof MessageEvent) {
            MessageEvent event = (MessageEvent)e;
            if (event.getMessage() instanceof ChannelBuffer) {
                ChannelBuffer buffer = (ChannelBuffer)event.getMessage();
                buffer.readBytes(this.outputStream, buffer.readableBytes());
                this.outputStream.flush();
                future.setSuccess();
            } else {
                throw new IllegalArgumentException("Only ChannelBuffer objects are supported to be written onto the IOStreamChannelSink! Please check if the encoder pipeline is configured correctly.");
            }
        }
    }

    private static class ReadRunnable
    implements Runnable {
        private final IoStreamChannelSink channelSink;

        public ReadRunnable(IoStreamChannelSink channelSink) {
            this.channelSink = channelSink;
        }

        @Override
        public void run() {
            PushbackInputStream in = this.channelSink.inputStream;
            while (this.channelSink.channel.isOpen()) {
                int readBytes;
                byte[] buf;
                block4: {
                    try {
                        int bytesToRead = in.available();
                        if (bytesToRead > 0) {
                            buf = new byte[bytesToRead];
                            readBytes = in.read(buf);
                            break block4;
                        }
                        int b = in.read();
                        if (b < 0) break;
                        in.unread(b);
                        continue;
                    }
                    catch (Throwable t) {
                        if (this.channelSink.channel.getCloseFuture().isDone()) break;
                        Channels.fireExceptionCaught(this.channelSink.channel, t);
                        break;
                    }
                }
                Channels.fireMessageReceived(this.channelSink.channel, (Object)ChannelBuffers.wrappedBuffer(buf, 0, readBytes));
            }
            Channels.close(this.channelSink.channel);
        }
    }
}

