/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.frame;

import io.netty.buffer.ChannelBuffer;
import io.netty.buffer.ChannelBuffers;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.frame.FrameDecoder;

public class FixedLengthFrameDecoder
extends FrameDecoder {
    private final int frameLength;
    private final boolean allocateFullBuffer;

    public FixedLengthFrameDecoder(int frameLength) {
        this(frameLength, false);
    }

    public FixedLengthFrameDecoder(int frameLength, boolean allocateFullBuffer) {
        if (frameLength <= 0) {
            throw new IllegalArgumentException("frameLength must be a positive integer: " + frameLength);
        }
        this.frameLength = frameLength;
        this.allocateFullBuffer = allocateFullBuffer;
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        if (buffer.readableBytes() < this.frameLength) {
            return null;
        }
        return buffer.readBytes(this.frameLength);
    }

    @Override
    protected ChannelBuffer createCumulationDynamicBuffer(ChannelHandlerContext ctx) {
        if (this.allocateFullBuffer) {
            return ChannelBuffers.dynamicBuffer(this.frameLength, ctx.getChannel().getConfig().getBufferFactory());
        }
        return super.createCumulationDynamicBuffer(ctx);
    }
}

