/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ChannelBuffer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDownstreamHandler;
import io.netty.channel.ChannelEvent;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelUpstreamHandler;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMessageDecoder;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.util.internal.QueueFactory;
import java.util.Queue;

public class HttpClientCodec
implements ChannelUpstreamHandler,
ChannelDownstreamHandler {
    final Queue<HttpMethod> queue = QueueFactory.createQueue(HttpMethod.class);
    volatile boolean done;
    private final HttpRequestEncoder encoder = new Encoder();
    private final HttpResponseDecoder decoder;

    public HttpClientCodec() {
        this(4096, 8192, 8192);
    }

    public HttpClientCodec(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize) {
        this.decoder = new Decoder(maxInitialLineLength, maxHeaderSize, maxChunkSize);
    }

    @Override
    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        this.decoder.handleUpstream(ctx, e);
    }

    @Override
    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        this.encoder.handleDownstream(ctx, e);
    }

    private final class Decoder
    extends HttpResponseDecoder {
        Decoder(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize) {
            super(maxInitialLineLength, maxHeaderSize, maxChunkSize);
        }

        @Override
        protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, HttpMessageDecoder.State state) throws Exception {
            if (HttpClientCodec.this.done) {
                return buffer.readBytes(this.actualReadableBytes());
            }
            return super.decode(ctx, channel, buffer, state);
        }

        @Override
        protected boolean isContentAlwaysEmpty(HttpMessage msg) {
            int statusCode = ((HttpResponse)msg).getStatus().getCode();
            if (statusCode == 100) {
                return true;
            }
            HttpMethod method = HttpClientCodec.this.queue.poll();
            char firstChar = method.getName().charAt(0);
            switch (firstChar) {
                case 'H': {
                    if (!HttpMethod.HEAD.equals(method)) break;
                    return true;
                }
                case 'C': {
                    if (statusCode != 200 || !HttpMethod.CONNECT.equals(method)) break;
                    HttpClientCodec.this.done = true;
                    HttpClientCodec.this.queue.clear();
                    return true;
                }
            }
            return super.isContentAlwaysEmpty(msg);
        }
    }

    private final class Encoder
    extends HttpRequestEncoder {
        Encoder() {
        }

        @Override
        protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
            if (msg instanceof HttpRequest && !HttpClientCodec.this.done) {
                HttpClientCodec.this.queue.offer(((HttpRequest)msg).getMethod());
            }
            return super.encode(ctx, channel, msg);
        }
    }
}

