/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ChannelBuffer;
import io.netty.buffer.ChannelBuffers;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpChunkAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocket00FrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocket00FrameEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketUtil;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.logging.InternalLogger;
import io.netty.logging.InternalLoggerFactory;

public class WebSocketServerHandshaker00
extends WebSocketServerHandshaker {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocketServerHandshaker00.class);

    public WebSocketServerHandshaker00(String webSocketURL, String subprotocols) {
        super(WebSocketVersion.V00, webSocketURL, subprotocols);
    }

    @Override
    public ChannelFuture handshake(Channel channel, HttpRequest req) {
        String protocol;
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Channel %s WS Version 00 server handshake", channel.getId()));
        }
        if (!"Upgrade".equalsIgnoreCase(req.getHeader("Connection")) || !"WebSocket".equalsIgnoreCase(req.getHeader("Upgrade"))) {
            throw new WebSocketHandshakeException("not a WebSocket handshake request: missing upgrade");
        }
        boolean isHixie76 = req.containsHeader("Sec-WebSocket-Key1") && req.containsHeader("Sec-WebSocket-Key2");
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, new HttpResponseStatus(101, isHixie76 ? "WebSocket Protocol Handshake" : "Web Socket Protocol Handshake"));
        res.addHeader("Upgrade", "WebSocket");
        res.addHeader("Connection", "Upgrade");
        if (isHixie76) {
            res.addHeader("Sec-WebSocket-Origin", req.getHeader("Origin"));
            res.addHeader("Sec-WebSocket-Location", this.getWebSocketUrl());
            protocol = req.getHeader("Sec-WebSocket-Protocol");
            if (protocol != null) {
                res.addHeader("Sec-WebSocket-Protocol", this.selectSubprotocol(protocol));
            }
            String key1 = req.getHeader("Sec-WebSocket-Key1");
            String key2 = req.getHeader("Sec-WebSocket-Key2");
            int a = (int)(Long.parseLong(key1.replaceAll("[^0-9]", "")) / (long)key1.replaceAll("[^ ]", "").length());
            int b = (int)(Long.parseLong(key2.replaceAll("[^0-9]", "")) / (long)key2.replaceAll("[^ ]", "").length());
            long c = req.getContent().readLong();
            ChannelBuffer input = ChannelBuffers.buffer(16);
            input.writeInt(a);
            input.writeInt(b);
            input.writeLong(c);
            ChannelBuffer output = ChannelBuffers.wrappedBuffer(WebSocketUtil.md5(input.array()));
            res.setContent(output);
        } else {
            res.addHeader("WebSocket-Origin", req.getHeader("Origin"));
            res.addHeader("WebSocket-Location", this.getWebSocketUrl());
            protocol = req.getHeader("WebSocket-Protocol");
            if (protocol != null) {
                res.addHeader("WebSocket-Protocol", this.selectSubprotocol(protocol));
            }
        }
        ChannelPipeline p = channel.getPipeline();
        if (p.get(HttpChunkAggregator.class) != null) {
            p.remove(HttpChunkAggregator.class);
        }
        p.replace(HttpRequestDecoder.class, "wsdecoder", (ChannelHandler)new WebSocket00FrameDecoder());
        ChannelFuture future = channel.write(res);
        p.replace(HttpResponseEncoder.class, "wsencoder", (ChannelHandler)new WebSocket00FrameEncoder());
        return future;
    }

    @Override
    public ChannelFuture close(Channel channel, CloseWebSocketFrame frame) {
        return channel.write(frame);
    }
}

