/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.buffer.ChannelBuffer;

final class SpdyCodecUtil {
    static final int SPDY_VERSION = 2;
    static final int SPDY_HEADER_TYPE_OFFSET = 2;
    static final int SPDY_HEADER_FLAGS_OFFSET = 4;
    static final int SPDY_HEADER_LENGTH_OFFSET = 5;
    static final int SPDY_HEADER_SIZE = 8;
    static final int SPDY_MAX_LENGTH = 0xFFFFFF;
    static final byte SPDY_DATA_FLAG_FIN = 1;
    static final byte SPDY_DATA_FLAG_COMPRESS = 2;
    static final int SPDY_SYN_STREAM_FRAME = 1;
    static final int SPDY_SYN_REPLY_FRAME = 2;
    static final int SPDY_RST_STREAM_FRAME = 3;
    static final int SPDY_SETTINGS_FRAME = 4;
    static final int SPDY_NOOP_FRAME = 5;
    static final int SPDY_PING_FRAME = 6;
    static final int SPDY_GOAWAY_FRAME = 7;
    static final int SPDY_HEADERS_FRAME = 8;
    static final int SPDY_WINDOW_UPDATE_FRAME = 9;
    static final byte SPDY_FLAG_FIN = 1;
    static final byte SPDY_FLAG_UNIDIRECTIONAL = 2;
    static final byte SPDY_SETTINGS_CLEAR = 1;
    static final byte SPDY_SETTINGS_PERSIST_VALUE = 1;
    static final byte SPDY_SETTINGS_PERSISTED = 2;
    static final int SPDY_SETTINGS_MAX_ID = 0xFFFFFF;
    static final int SPDY_MAX_NV_LENGTH = 65535;
    private static final String SPDY_DICT_S = "optionsgetheadpostputdeletetraceacceptaccept-charsetaccept-encodingaccept-languageauthorizationexpectfromhostif-modified-sinceif-matchif-none-matchif-rangeif-unmodifiedsincemax-forwardsproxy-authorizationrangerefererteuser-agent100101200201202203204205206300301302303304305306307400401402403404405406407408409410411412413414415416417500501502503504505accept-rangesageetaglocationproxy-authenticatepublicretry-afterservervarywarningwww-authenticateallowcontent-basecontent-encodingcache-controlconnectiondatetrailertransfer-encodingupgradeviawarningcontent-languagecontent-lengthcontent-locationcontent-md5content-rangecontent-typeetagexpireslast-modifiedset-cookieMondayTuesdayWednesdayThursdayFridaySaturdaySundayJanFebMarAprMayJunJulAugSepOctNovDecchunkedtext/htmlimage/pngimage/jpgimage/gifapplication/xmlapplication/xhtmltext/plainpublicmax-agecharset=iso-8859-1utf-8gzipdeflateHTTP/1.1statusversionurl ";
    static final byte[] SPDY_DICT;

    private SpdyCodecUtil() {
    }

    static int getUnsignedShort(ChannelBuffer buf, int offset) {
        return (buf.getByte(offset) & 0xFF) << 8 | buf.getByte(offset + 1) & 0xFF;
    }

    static int getUnsignedMedium(ChannelBuffer buf, int offset) {
        return (buf.getByte(offset) & 0xFF) << 16 | (buf.getByte(offset + 1) & 0xFF) << 8 | buf.getByte(offset + 2) & 0xFF;
    }

    static int getUnsignedInt(ChannelBuffer buf, int offset) {
        return (buf.getByte(offset) & 0x7F) << 24 | (buf.getByte(offset + 1) & 0xFF) << 16 | (buf.getByte(offset + 2) & 0xFF) << 8 | buf.getByte(offset + 3) & 0xFF;
    }

    static int getSignedInt(ChannelBuffer buf, int offset) {
        return (buf.getByte(offset) & 0xFF) << 24 | (buf.getByte(offset + 1) & 0xFF) << 16 | (buf.getByte(offset + 2) & 0xFF) << 8 | buf.getByte(offset + 3) & 0xFF;
    }

    static boolean isServerID(int ID) {
        return ID % 2 == 0;
    }

    static void validateHeaderName(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("name cannot be length zero");
        }
        if (name.length() > 65535) {
            throw new IllegalArgumentException("name exceeds allowable length: " + name);
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '\u0000') {
                throw new IllegalArgumentException("name contains null character: " + name);
            }
            if (c <= '\u007f') continue;
            throw new IllegalArgumentException("name contains non-ascii character: " + name);
        }
    }

    static void validateHeaderValue(String value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (value.length() == 0) {
            throw new IllegalArgumentException("value cannot be length zero");
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c != '\u0000') continue;
            throw new IllegalArgumentException("value contains null character: " + value);
        }
    }

    static {
        byte[] SPDY_DICT_ = null;
        try {
            SPDY_DICT_ = SPDY_DICT_S.getBytes("US-ASCII");
            SPDY_DICT_[SPDY_DICT_.length - 1] = 0;
        }
        catch (Exception e) {
            SPDY_DICT_ = new byte[1];
        }
        SPDY_DICT = SPDY_DICT_;
    }
}

