/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.stream;

import io.netty.buffer.ChannelBuffers;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDownstreamHandler;
import io.netty.channel.ChannelEvent;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelStateEvent;
import io.netty.channel.ChannelUpstreamHandler;
import io.netty.channel.Channels;
import io.netty.channel.MessageEvent;
import io.netty.handler.stream.ChunkedInput;
import io.netty.logging.InternalLogger;
import io.netty.logging.InternalLoggerFactory;
import io.netty.util.internal.QueueFactory;
import java.nio.channels.ClosedChannelException;
import java.util.Queue;

public class ChunkedWriteHandler
implements ChannelUpstreamHandler,
ChannelDownstreamHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChunkedWriteHandler.class);
    private final Queue<MessageEvent> queue = QueueFactory.createQueue(MessageEvent.class);
    private ChannelHandlerContext ctx;
    private MessageEvent currentEvent;

    public void resumeTransfer() {
        block3: {
            ChannelHandlerContext ctx = this.ctx;
            if (ctx == null) {
                return;
            }
            try {
                this.flush(ctx);
            }
            catch (Exception e) {
                if (!logger.isWarnEnabled()) break block3;
                logger.warn("Unexpected exception while sending chunks.", e);
            }
        }
    }

    @Override
    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (!(e instanceof MessageEvent)) {
            ctx.sendDownstream(e);
            return;
        }
        boolean offered = this.queue.offer((MessageEvent)e);
        assert (offered);
        Channel channel = ctx.getChannel();
        if (channel.isWritable()) {
            this.ctx = ctx;
            this.flush(ctx);
        } else if (!channel.isConnected()) {
            this.ctx = ctx;
            this.discard(ctx);
        }
    }

    @Override
    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent cse = (ChannelStateEvent)e;
            switch (cse.getState()) {
                case INTEREST_OPS: {
                    this.flush(ctx);
                    break;
                }
                case OPEN: {
                    if (Boolean.TRUE.equals(cse.getValue())) break;
                    this.discard(ctx);
                }
            }
        }
        ctx.sendUpstream(e);
    }

    private void discard(ChannelHandlerContext ctx) {
        ClosedChannelException cause = null;
        boolean fireExceptionCaught = false;
        while (true) {
            MessageEvent currentEvent = this.currentEvent;
            if (this.currentEvent == null) {
                currentEvent = this.queue.poll();
            } else {
                this.currentEvent = null;
            }
            if (currentEvent == null) break;
            Object m = currentEvent.getMessage();
            if (m instanceof ChunkedInput) {
                ChunkedWriteHandler.closeInput((ChunkedInput)m);
            }
            if (cause == null) {
                cause = new ClosedChannelException();
            }
            currentEvent.getFuture().setFailure(cause);
            fireExceptionCaught = true;
            currentEvent = null;
        }
        if (fireExceptionCaught) {
            Channels.fireExceptionCaught(ctx.getChannel(), cause);
        }
    }

    private synchronized void flush(ChannelHandlerContext ctx) throws Exception {
        Channel channel = ctx.getChannel();
        if (!channel.isConnected()) {
            this.discard(ctx);
        }
        while (channel.isWritable()) {
            if (this.currentEvent == null) {
                this.currentEvent = this.queue.poll();
            }
            if (this.currentEvent == null) break;
            if (this.currentEvent.getFuture().isDone()) {
                this.currentEvent = null;
            } else {
                final MessageEvent currentEvent = this.currentEvent;
                Object m = currentEvent.getMessage();
                if (m instanceof ChunkedInput) {
                    ChannelFuture writeFuture;
                    boolean suspend;
                    boolean endOfInput;
                    Object chunk;
                    ChunkedInput chunks = (ChunkedInput)m;
                    try {
                        chunk = chunks.nextChunk();
                        endOfInput = chunks.isEndOfInput();
                        if (chunk == null) {
                            chunk = ChannelBuffers.EMPTY_BUFFER;
                            suspend = !endOfInput;
                        } else {
                            suspend = false;
                        }
                    }
                    catch (Throwable t) {
                        this.currentEvent = null;
                        currentEvent.getFuture().setFailure(t);
                        Channels.fireExceptionCaught(ctx, t);
                        ChunkedWriteHandler.closeInput(chunks);
                        break;
                    }
                    if (suspend) break;
                    if (endOfInput) {
                        this.currentEvent = null;
                        ChunkedWriteHandler.closeInput(chunks);
                        writeFuture = currentEvent.getFuture();
                    } else {
                        writeFuture = Channels.future(channel);
                        writeFuture.addListener(new ChannelFutureListener(){

                            @Override
                            public void operationComplete(ChannelFuture future) throws Exception {
                                if (!future.isSuccess()) {
                                    currentEvent.getFuture().setFailure(future.getCause());
                                    ChunkedWriteHandler.closeInput((ChunkedInput)currentEvent.getMessage());
                                }
                            }
                        });
                    }
                    Channels.write(ctx, writeFuture, chunk, currentEvent.getRemoteAddress());
                } else {
                    this.currentEvent = null;
                    ctx.sendDownstream(currentEvent);
                }
            }
            if (channel.isConnected()) continue;
            this.discard(ctx);
            break;
        }
    }

    static void closeInput(ChunkedInput chunks) {
        block2: {
            try {
                chunks.close();
            }
            catch (Throwable t) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("Failed to close a chunked input.", t);
            }
        }
    }
}

