/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.component;

import java.util.logging.Level;
import org.restlet.Client;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Protocol;
import org.restlet.routing.Route;
import org.restlet.routing.Router;

public class ClientRoute
extends Route {
    public ClientRoute(Router router, Client target) {
        super(router, (Restlet)target);
    }

    public Client getClient() {
        return (Client)this.getNext();
    }

    public float score(Request request, Response response) {
        float result = 0.0f;
        Protocol protocol = request.getProtocol();
        if (protocol == null) {
            this.getLogger().warning("Unable to determine the protocol to use for this call.");
        } else if (this.getClient().getProtocols().contains(protocol)) {
            result = 1.0f;
        }
        if (this.getLogger().isLoggable(Level.FINER)) {
            this.getLogger().finer("Call score for the \"" + this.getClient().getProtocols().toString() + "\" client: " + result);
        }
        return result;
    }

    public void setNext(Client next) {
        super.setNext(next);
    }
}

