/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.local;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.restlet.data.Disposition;
import org.restlet.data.MediaType;
import org.restlet.engine.io.BioUtils;
import org.restlet.representation.StreamRepresentation;

public class ZipEntryRepresentation
extends StreamRepresentation {
    protected final ZipFile zipFile;
    protected final ZipEntry entry;

    public ZipEntryRepresentation(MediaType mediaType, ZipFile zipFile, ZipEntry entry) {
        super(mediaType);
        this.zipFile = zipFile;
        this.entry = entry;
        Disposition disposition = new Disposition();
        disposition.setFilename(entry.getName());
        this.setDisposition(disposition);
        this.setSize(entry.getSize());
        this.setModificationDate(new Date(entry.getTime()));
    }

    public void release() {
        try {
            this.zipFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public InputStream getStream() throws IOException {
        return this.zipFile.getInputStream(this.entry);
    }

    public void write(OutputStream outputStream) throws IOException {
        BioUtils.copy(this.getStream(), outputStream);
    }
}

