/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jgroups.Address;
import org.jgroups.AnycastAddress;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.blocks.RspCollector;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.relay.SiteMaster;
import org.jgroups.stack.DiagnosticsHandler;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Buffer;
import org.jgroups.util.Util;

public class RequestCorrelator {
    protected Protocol transport = null;
    protected final ConcurrentMap<Long, RspCollector> requests = Util.createConcurrentMap();
    protected RequestHandler request_handler = null;
    protected RpcDispatcher.Marshaller marshaller = null;
    protected short id = ClassConfigurator.getProtocolId(this.getClass());
    protected Address local_addr = null;
    protected volatile View view;
    protected boolean started = false;
    private final MyProbeHandler probe_handler = new MyProbeHandler(this.requests);
    protected static final Log log = LogFactory.getLog(RequestCorrelator.class);

    public RequestCorrelator(short id, Protocol transport, RequestHandler handler, Address local_addr) {
        this.id = id;
        this.transport = transport;
        this.local_addr = local_addr;
        this.request_handler = handler;
        this.start();
    }

    public RequestCorrelator(Protocol transport, RequestHandler handler, Address local_addr) {
        this.transport = transport;
        this.local_addr = local_addr;
        this.request_handler = handler;
        this.start();
    }

    public void setRequestHandler(RequestHandler handler) {
        this.request_handler = handler;
        this.start();
    }

    public RpcDispatcher.Marshaller getMarshaller() {
        return this.marshaller;
    }

    public void setMarshaller(RpcDispatcher.Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public void sendRequest(long id, List<Address> dest_mbrs, Message msg, RspCollector coll) throws Exception {
        this.sendRequest(id, dest_mbrs, msg, coll, new RequestOptions().setAnycasting(false));
    }

    public void sendRequest(long id, Collection<Address> dest_mbrs, Message msg, RspCollector coll, RequestOptions options) throws Exception {
        if (this.transport == null) {
            if (log.isWarnEnabled()) {
                log.warn("transport is not available !");
            }
            return;
        }
        Header hdr = options.hasExclusionList() ? new MultiDestinationHeader(0, id, coll != null, this.id, options.getExclusionList()) : new Header(0, id, coll != null, this.id);
        msg.putHeader(this.id, hdr);
        if (coll != null) {
            this.addEntry(hdr.id, coll);
            coll.viewChange(this.view);
        }
        if (options.getAnycasting()) {
            if (options.useAnycastAddresses()) {
                Message copy = msg.copy(true);
                AnycastAddress dest = new AnycastAddress(dest_mbrs);
                copy.setDest(dest);
                this.transport.down(new Event(1, copy));
            } else {
                for (Address mbr : dest_mbrs) {
                    Message copy = msg.copy(true);
                    copy.setDest(mbr);
                    this.transport.down(new Event(1, copy));
                }
            }
        } else {
            this.transport.down(new Event(1, msg));
        }
    }

    public void sendUnicastRequest(long id, Address target, Message msg, RspCollector coll) throws Exception {
        if (this.transport == null) {
            if (log.isWarnEnabled()) {
                log.warn("transport is not available !");
            }
            return;
        }
        Header hdr = new Header(0, id, coll != null, this.id);
        msg.putHeader(this.id, hdr);
        if (coll != null) {
            this.addEntry(hdr.id, coll);
            coll.viewChange(this.view);
        }
        this.transport.down(new Event(1, msg));
    }

    public void done(long id) {
        this.removeEntry(id);
    }

    public boolean receive(Event evt) {
        switch (evt.getType()) {
            case 9: {
                this.receiveSuspect((Address)evt.getArg());
                break;
            }
            case 6: {
                this.receiveView((View)evt.getArg());
                break;
            }
            case 8: {
                this.setLocalAddress((Address)evt.getArg());
                break;
            }
            case 1: {
                if (!this.receiveMessage((Message)evt.getArg())) break;
                return true;
            }
            case 104: {
                SiteMaster site_master = (SiteMaster)evt.getArg();
                short site = site_master.getSite();
                this.setSiteUnreachable(site);
                return true;
            }
        }
        return false;
    }

    public final void start() {
        this.started = true;
    }

    public void stop() {
        this.started = false;
        for (RspCollector coll : this.requests.values()) {
            coll.transportClosed();
        }
        this.requests.clear();
    }

    public void registerProbeHandler(TP transport) {
        if (transport != null) {
            transport.registerProbeHandler(this.probe_handler);
        }
    }

    public void unregisterProbeHandler(TP transport) {
        if (transport != null) {
            transport.unregisterProbeHandler(this.probe_handler);
        }
    }

    public void receiveSuspect(Address mbr) {
        if (mbr == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("suspect=" + mbr);
        }
        for (RspCollector coll : this.requests.values()) {
            if (coll == null) continue;
            coll.suspect(mbr);
        }
    }

    public void setSiteUnreachable(short site) {
        for (RspCollector coll : this.requests.values()) {
            if (coll == null) continue;
            coll.siteUnreachable(site);
        }
    }

    public void receiveView(View new_view) {
        this.view = new_view;
        for (RspCollector coll : this.requests.values()) {
            if (coll == null) continue;
            coll.viewChange(new_view);
        }
    }

    public boolean receiveMessage(Message msg) {
        Collection<? extends Address> exclusion_list;
        Header hdr = (Header)msg.getHeader(this.id);
        if (hdr == null) {
            return false;
        }
        if (hdr.corrId != this.id) {
            if (log.isTraceEnabled()) {
                log.trace(new StringBuilder("id of request correlator header (").append(hdr.corrId).append(") is different from ours (").append(this.id).append("). Msg not accepted, passed up"));
            }
            return false;
        }
        if (hdr instanceof MultiDestinationHeader && (exclusion_list = ((MultiDestinationHeader)hdr).exclusion_list) != null && this.local_addr != null && exclusion_list.contains(this.local_addr)) {
            if (log.isTraceEnabled()) {
                log.trace(new StringBuilder("discarded request from ").append(msg.getSrc()).append(" as we are in the exclusion list (local_addr=").append(this.local_addr).append(", hdr=").append(hdr).append(')'));
            }
            return true;
        }
        switch (hdr.type) {
            case 0: {
                if (this.request_handler == null) {
                    if (log.isWarnEnabled()) {
                        log.warn("there is no request handler installed to deliver request !");
                    }
                    return true;
                }
                this.handleRequest(msg, hdr);
                break;
            }
            case 1: 
            case 2: {
                Object retval;
                RspCollector coll = (RspCollector)this.requests.get(hdr.id);
                if (coll == null) break;
                boolean is_exception = hdr.type == 2;
                Address sender = msg.getSrc();
                byte[] buf = msg.getBuffer();
                int offset = msg.getOffset();
                int length = msg.getLength();
                try {
                    retval = this.marshaller != null ? this.marshaller.objectFromBuffer(buf, offset, length) : Util.objectFromByteBuffer(buf, offset, length);
                }
                catch (Exception e) {
                    log.error("failed unmarshalling buffer into return value", e);
                    retval = e;
                    is_exception = true;
                }
                coll.receiveResponse(retval, sender, is_exception);
                break;
            }
            default: {
                msg.getHeader(this.id);
                if (!log.isErrorEnabled()) break;
                log.error("header's type is neither REQ nor RSP !");
            }
        }
        return true;
    }

    public Address getLocalAddress() {
        return this.local_addr;
    }

    public void setLocalAddress(Address local_addr) {
        this.local_addr = local_addr;
    }

    private void addEntry(long id, RspCollector coll) {
        this.requests.putIfAbsent(id, coll);
    }

    private void removeEntry(long id) {
        this.requests.remove(id);
    }

    protected void handleRequest(Message req, Header hdr) {
        byte[] rsp_buf;
        Object retval;
        boolean threw_exception = false;
        if (log.isTraceEnabled()) {
            log.trace(new StringBuilder("calling (").append(this.request_handler != null ? this.request_handler.getClass().getName() : "null").append(") with request ").append(hdr.id));
        }
        try {
            retval = this.request_handler.handle(req);
        }
        catch (Throwable t) {
            threw_exception = true;
            retval = t;
        }
        if (!hdr.rsp_expected) {
            return;
        }
        if (this.transport == null) {
            if (log.isErrorEnabled()) {
                log.error("failure sending response; no transport available");
            }
            return;
        }
        try {
            rsp_buf = this.marshaller != null ? (Object)this.marshaller.objectToBuffer(retval) : Util.objectToByteBuffer(retval);
        }
        catch (Throwable t) {
            try {
                rsp_buf = this.marshaller != null ? (Object)this.marshaller.objectToBuffer(t) : Util.objectToByteBuffer(t);
                threw_exception = true;
            }
            catch (Throwable tt) {
                if (log.isErrorEnabled()) {
                    log.error("failed sending rsp: return value (" + retval + ") is not serializable");
                }
                return;
            }
        }
        Message rsp = req.makeReply();
        this.prepareResponse(rsp);
        rsp.setFlag(Message.OOB);
        rsp.setFlag(Message.DONT_BUNDLE);
        if (req.isFlagSet(Message.NO_FC)) {
            rsp.setFlag(Message.NO_FC);
        }
        if (req.isFlagSet(Message.NO_RELIABILITY)) {
            rsp.setFlag(Message.NO_RELIABILITY);
        }
        if (req.isFlagSet(Message.NO_TOTAL_ORDER)) {
            rsp.setFlag(Message.NO_TOTAL_ORDER);
        }
        if (rsp_buf instanceof Buffer) {
            rsp.setBuffer((Buffer)rsp_buf);
        } else if (rsp_buf instanceof byte[]) {
            rsp.setBuffer(rsp_buf);
        }
        Header rsp_hdr = new Header(threw_exception ? (byte)2 : 1, hdr.id, false, this.id);
        rsp.putHeader(this.id, rsp_hdr);
        if (log.isTraceEnabled()) {
            log.trace(new StringBuilder("sending rsp for ").append(rsp_hdr.id).append(" to ").append(rsp.getDest()));
        }
        this.transport.down(new Event(1, rsp));
    }

    protected void prepareResponse(Message rsp) {
    }

    private static class MyProbeHandler
    implements DiagnosticsHandler.ProbeHandler {
        private final ConcurrentMap<Long, RspCollector> requests;

        private MyProbeHandler(ConcurrentMap<Long, RspCollector> requests) {
            this.requests = requests;
        }

        @Override
        public Map<String, String> handleProbe(String ... keys) {
            if (this.requests == null) {
                return null;
            }
            HashMap<String, String> retval = new HashMap<String, String>();
            for (String key : keys) {
                if (!key.equals("requests")) continue;
                StringBuilder sb = new StringBuilder();
                for (Map.Entry entry : this.requests.entrySet()) {
                    sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
                }
                retval.put("requests", sb.toString());
                break;
            }
            return retval;
        }

        @Override
        public String[] supportedKeys() {
            return new String[]{"requests"};
        }
    }

    public static final class MultiDestinationHeader
    extends Header {
        public Collection<? extends Address> exclusion_list;

        public MultiDestinationHeader() {
        }

        public MultiDestinationHeader(byte type, long id, boolean rsp_expected, short corr_id, Collection<Address> exclusion_list) {
            super(type, id, rsp_expected, corr_id);
            this.exclusion_list = exclusion_list;
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            super.writeTo(out);
            Util.writeAddresses(this.exclusion_list, out);
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            super.readFrom(in);
            this.exclusion_list = Util.readAddresses(in, LinkedList.class);
        }

        @Override
        public int size() {
            return (int)((long)super.size() + Util.size(this.exclusion_list));
        }

        @Override
        public String toString() {
            String str = super.toString();
            if (this.exclusion_list != null) {
                str = str + ", exclusion_list=" + this.exclusion_list;
            }
            return str;
        }
    }

    public static class Header
    extends org.jgroups.Header {
        public static final byte REQ = 0;
        public static final byte RSP = 1;
        public static final byte EXC_RSP = 2;
        public byte type;
        public long id;
        public boolean rsp_expected;
        public short corrId;

        public Header() {
        }

        public Header(byte type, long id, boolean rsp_expected, short corr_id) {
            this.type = type;
            this.id = id;
            this.rsp_expected = rsp_expected;
            this.corrId = corr_id;
        }

        @Override
        public String toString() {
            StringBuilder ret = new StringBuilder();
            ret.append("id=" + this.corrId + ", type=");
            switch (this.type) {
                case 0: {
                    ret.append("REQ");
                    break;
                }
                case 1: {
                    ret.append("RSP");
                    break;
                }
                case 2: {
                    ret.append("EXC_RSP");
                    break;
                }
                default: {
                    ret.append("<unknown>");
                }
            }
            ret.append(", id=" + this.id);
            ret.append(", rsp_expected=" + this.rsp_expected);
            return ret.toString();
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            out.writeByte(this.type);
            Util.writeLong(this.id, out);
            out.writeBoolean(this.rsp_expected);
            out.writeShort(this.corrId);
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.type = in.readByte();
            this.id = Util.readLong(in);
            this.rsp_expected = in.readBoolean();
            this.corrId = in.readShort();
        }

        @Override
        public int size() {
            return 1 + Util.size(this.id) + 1 + 2;
        }
    }
}

