/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import org.apache.helix.ZNRecord;
import org.apache.helix.manager.zk.ZNRecordSerializer;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Message;
import org.apache.helix.tools.ZKLogFormatter;
import org.apache.log4j.Logger;

public class ZkLogAnalyzer {
    private static Logger LOG = Logger.getLogger(ZkLogAnalyzer.class);
    private static boolean dump = false;
    static final ZNRecordSerializer _deserializer = new ZNRecordSerializer();

    static String getAttributeValue(String line, String attribute) {
        if (line == null) {
            return null;
        }
        String[] parts = line.split("\\s");
        if (parts != null && parts.length > 0) {
            for (int i = 0; i < parts.length; ++i) {
                if (!parts[i].startsWith(attribute)) continue;
                String val = parts[i].substring(attribute.length());
                return val;
            }
        }
        return null;
    }

    static String findLastCSUpdateBetween(List<String> csUpdateLines, long start, long end) {
        long lastCSUpdateTimestamp = Long.MIN_VALUE;
        String lastCSUpdateLine = null;
        for (String line : csUpdateLines) {
            long timestamp = Long.parseLong(ZkLogAnalyzer.getAttributeValue(line, "time:"));
            if (timestamp < start || timestamp > end || timestamp <= lastCSUpdateTimestamp) continue;
            lastCSUpdateTimestamp = timestamp;
            lastCSUpdateLine = line;
        }
        assert (lastCSUpdateLine != null) : "No CS update between " + start + " - " + end;
        return lastCSUpdateLine;
    }

    static ZNRecord getZNRecord(String line) {
        ZNRecord record = null;
        String value = ZkLogAnalyzer.getAttributeValue(line, "data:");
        if (value != null) {
            record = (ZNRecord)_deserializer.deserialize(value.getBytes());
        }
        return record;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            System.err.println("USAGE: ZkLogAnalyzer zkLogDir clusterName testStartTime (yyMMdd_hhmmss_SSS)");
            System.exit(1);
        }
        System.out.println("ZkLogAnalyzer called with args: " + Arrays.toString(args));
        String zkLogDir = args[0];
        String clusterName = args[1];
        String startTimeStr = args[2];
        SimpleDateFormat formatter = new SimpleDateFormat("yyMMdd_hhmmss_SSS");
        Date date = formatter.parse(startTimeStr);
        long startTimeStamp = date.getTime();
        System.out.println(clusterName + " created at " + date);
        while (zkLogDir.endsWith("/")) {
            zkLogDir = zkLogDir.substring(0, zkLogDir.length() - 1);
        }
        if (!zkLogDir.endsWith("/version-2")) {
            zkLogDir = zkLogDir + "/version-2";
        }
        File dir = new File(zkLogDir);
        File[] zkLogs = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().indexOf("log") != -1;
            }
        });
        TreeMap<Long, String> lastZkLogs = new TreeMap<Long, String>();
        for (File file : zkLogs) {
            if (file.lastModified() <= startTimeStamp) continue;
            lastZkLogs.put(file.lastModified(), file.getAbsolutePath());
        }
        ArrayList<String> parsedZkLogs = new ArrayList<String>();
        int i = 0;
        System.out.println("zk logs last modified later than " + new Timestamp(startTimeStamp));
        for (Long lastModified : lastZkLogs.keySet()) {
            String fileName = (String)lastZkLogs.get(lastModified);
            System.out.println(new Timestamp(lastModified) + ": " + fileName.substring(fileName.lastIndexOf(47) + 1));
            String parsedFileName = "zkLogAnalyzor_zklog.parsed" + i;
            ++i;
            ZKLogFormatter.main(new String[]{"log", fileName, parsedFileName});
            parsedZkLogs.add(parsedFileName);
        }
        HashMap<String, String> sessionMap = new HashMap<String, String>();
        ArrayList<String> csUpdateLines = new ArrayList<String>();
        String leaderSession = null;
        System.out.println();
        Stats stats = new Stats();
        long lastTestStartTimestamp = Long.MAX_VALUE;
        long controllerStartTime = 0L;
        for (String parsedZkLog : parsedZkLogs) {
            String inputLine;
            FileInputStream fis = new FileInputStream(parsedZkLog);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            while ((inputLine = br.readLine()) != null) {
                String session;
                LiveInstance liveInstance;
                ZNRecord record;
                String type;
                long timestampVal;
                String timestamp = ZkLogAnalyzer.getAttributeValue(inputLine, "time:");
                if (timestamp == null || (timestampVal = Long.parseLong(timestamp)) < startTimeStamp) continue;
                if (dump) {
                    String printLine = inputLine.replaceAll("data:.*", "");
                    printLine = new Timestamp(timestampVal) + " " + printLine.substring(printLine.indexOf("session:"));
                    System.err.println(printLine);
                }
                if (inputLine.indexOf("/start_disable") != -1) {
                    dump = true;
                }
                if (inputLine.indexOf("/" + clusterName + "/CONFIGS/CLUSTER/verify") != -1) {
                    type = ZkLogAnalyzer.getAttributeValue(inputLine, "type:");
                    if (!type.equals("delete")) continue;
                    System.out.println(timestamp + ": verify done");
                    System.out.println("lastTestStartTimestamp:" + lastTestStartTimestamp);
                    String lastCSUpdateLine = ZkLogAnalyzer.findLastCSUpdateBetween(csUpdateLines, lastTestStartTimestamp, timestampVal);
                    long lastCSUpdateTimestamp = Long.parseLong(ZkLogAnalyzer.getAttributeValue(lastCSUpdateLine, "time:"));
                    System.out.println("Last CS Update:" + lastCSUpdateTimestamp);
                    System.out.println("state transition latency: " + (lastCSUpdateTimestamp - lastTestStartTimestamp) + "ms");
                    System.out.println("state transition latency since controller start: " + (lastCSUpdateTimestamp - controllerStartTime) + "ms");
                    System.out.println("Create MSG\t" + stats.msgSentCount + "\t" + stats.msgSentCount_O2S + "\t" + stats.msgSentCount_S2M + "\t" + stats.msgSentCount_M2S);
                    System.out.println("Modify MSG\t" + stats.msgModifyCount);
                    System.out.println("Delete MSG\t" + stats.msgDeleteCount);
                    System.out.println("Create CS\t" + stats.curStateCreateCount);
                    System.out.println("Update CS\t" + stats.curStateUpdateCount);
                    System.out.println("Create EV\t" + stats.extViewCreateCount);
                    System.out.println("Update EV\t" + stats.extViewUpdateCount);
                    System.out.println();
                    stats = new Stats();
                    lastTestStartTimestamp = Long.MAX_VALUE;
                    continue;
                }
                if (inputLine.indexOf("/" + clusterName + "/LIVEINSTANCES/") != -1) {
                    if (timestampVal < lastTestStartTimestamp) {
                        System.out.println("START cluster. SETTING lastTestStartTimestamp to " + new Timestamp(timestampVal) + "\nline:" + inputLine);
                        lastTestStartTimestamp = timestampVal;
                    }
                    record = ZkLogAnalyzer.getZNRecord(inputLine);
                    liveInstance = new LiveInstance(record);
                    String session2 = ZkLogAnalyzer.getAttributeValue(inputLine, "session:");
                    sessionMap.put(session2, inputLine);
                    System.out.println(new Timestamp(Long.parseLong(timestamp)) + ": create LIVEINSTANCE " + liveInstance.getInstanceName());
                    continue;
                }
                if (inputLine.indexOf("closeSession") != -1) {
                    session = ZkLogAnalyzer.getAttributeValue(inputLine, "session:");
                    if (!sessionMap.containsKey(session)) continue;
                    if (timestampVal < lastTestStartTimestamp) {
                        System.out.println("KILL node. SETTING lastTestStartTimestamp to " + timestampVal + " line:" + inputLine);
                        lastTestStartTimestamp = timestampVal;
                    }
                    String line = (String)sessionMap.get(session);
                    ZNRecord record2 = ZkLogAnalyzer.getZNRecord(line);
                    LiveInstance liveInstance2 = new LiveInstance(record2);
                    System.out.println(new Timestamp(Long.parseLong(timestamp)) + ": close session " + liveInstance2.getInstanceName());
                    dump = true;
                    continue;
                }
                if (inputLine.indexOf("/" + clusterName + "/CONFIGS/PARTICIPANT") != -1) {
                    type = ZkLogAnalyzer.getAttributeValue(inputLine, "type:");
                    if (!type.equals("setData") || inputLine.indexOf("HELIX_DISABLED_PARTITION") == -1 || timestampVal >= lastTestStartTimestamp) continue;
                    System.out.println("DISABLE partition. SETTING lastTestStartTimestamp to " + timestampVal + " line:" + inputLine);
                    lastTestStartTimestamp = timestampVal;
                    continue;
                }
                if (inputLine.indexOf("/" + clusterName + "/CONTROLLER/LEADER") != -1) {
                    String session3;
                    record = ZkLogAnalyzer.getZNRecord(inputLine);
                    liveInstance = new LiveInstance(record);
                    leaderSession = session3 = ZkLogAnalyzer.getAttributeValue(inputLine, "session:");
                    controllerStartTime = Long.parseLong(ZkLogAnalyzer.getAttributeValue(inputLine, "time:"));
                    sessionMap.put(session3, inputLine);
                    System.out.println(new Timestamp(Long.parseLong(timestamp)) + ": create LEADER " + liveInstance.getInstanceName());
                    continue;
                }
                if (inputLine.indexOf("/" + clusterName + "/") != -1 && inputLine.indexOf("/CURRENTSTATES/") != -1) {
                    type = ZkLogAnalyzer.getAttributeValue(inputLine, "type:");
                    if (type.equals("create")) {
                        ++stats.curStateCreateCount;
                        continue;
                    }
                    if (!type.equals("setData")) continue;
                    String path = ZkLogAnalyzer.getAttributeValue(inputLine, "path:");
                    csUpdateLines.add(inputLine);
                    ++stats.curStateUpdateCount;
                    System.out.println("Update currentstate:" + new Timestamp(Long.parseLong(timestamp)) + ":" + timestamp + " path:" + path);
                    continue;
                }
                if (inputLine.indexOf("/" + clusterName + "/EXTERNALVIEW/") != -1) {
                    session = ZkLogAnalyzer.getAttributeValue(inputLine, "session:");
                    if (!session.equals(leaderSession)) continue;
                    String type2 = ZkLogAnalyzer.getAttributeValue(inputLine, "type:");
                    if (type2.equals("create")) {
                        ++stats.extViewCreateCount;
                        continue;
                    }
                    if (!type2.equals("setData")) continue;
                    ++stats.extViewUpdateCount;
                    continue;
                }
                if (inputLine.indexOf("/" + clusterName + "/") == -1 || inputLine.indexOf("/MESSAGES/") == -1) continue;
                type = ZkLogAnalyzer.getAttributeValue(inputLine, "type:");
                if (type.equals("create")) {
                    ZNRecord record3 = ZkLogAnalyzer.getZNRecord(inputLine);
                    Message msg = new Message(record3);
                    String sendSession = ZkLogAnalyzer.getAttributeValue(inputLine, "session:");
                    if (!sendSession.equals(leaderSession) || !msg.getMsgType().equals("STATE_TRANSITION") || msg.getMsgState() != Message.MessageState.NEW) continue;
                    ++stats.msgSentCount;
                    if (msg.getFromState().equals("OFFLINE") && msg.getToState().equals("SLAVE")) {
                        ++stats.msgSentCount_O2S;
                        continue;
                    }
                    if (msg.getFromState().equals("SLAVE") && msg.getToState().equals("MASTER")) {
                        ++stats.msgSentCount_S2M;
                        continue;
                    }
                    if (!msg.getFromState().equals("MASTER") || !msg.getToState().equals("SLAVE")) continue;
                    ++stats.msgSentCount_M2S;
                    continue;
                }
                if (type.equals("setData")) {
                    ++stats.msgModifyCount;
                    continue;
                }
                if (!type.equals("delete")) continue;
                ++stats.msgDeleteCount;
            }
        }
    }

    static class Stats {
        int msgSentCount = 0;
        int msgSentCount_O2S = 0;
        int msgSentCount_S2M = 0;
        int msgSentCount_M2S = 0;
        int msgDeleteCount = 0;
        int msgModifyCount = 0;
        int curStateCreateCount = 0;
        int curStateUpdateCount = 0;
        int extViewCreateCount = 0;
        int extViewUpdateCount = 0;

        Stats() {
        }
    }
}

