/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.server;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;

public class UberfireImageServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private Collection<String> paths = new ArrayList<String>();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            String path = this.getConfig(config, "org.uberfire.images.paths");
            if (path != null) {
                String[] paths;
                for (String currentPath : paths = path.split(",")) {
                    this.paths.add(currentPath);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String imageUrl = request.getParameter("url");
        if (imageUrl == null) {
            response.setStatus(404);
            return;
        }
        String imageFormat = this.getImageSuffix(imageUrl);
        byte[] imageData = this.readImageData(request, imageUrl);
        if (imageData == null) {
            response.setStatus(404);
            return;
        }
        if (imageFormat != null) {
            response.setContentType("image/" + imageFormat);
        }
        response.getOutputStream().write(imageData, 0, imageData.length);
    }

    private String getImageSuffix(String imageUrl) {
        int dotIndex = imageUrl.lastIndexOf(".");
        if (dotIndex == -1) {
            return null;
        }
        if (dotIndex == imageUrl.length()) {
            return null;
        }
        return imageUrl.substring(imageUrl.lastIndexOf(".") + 1);
    }

    private byte[] readImageData(HttpServletRequest request, String imageUrl) {
        String url = !imageUrl.startsWith("/") ? "/" + imageUrl : imageUrl;
        InputStream is = this.resolveInputStream(request, url);
        if (is == null) {
            return null;
        }
        BufferedInputStream bis = new BufferedInputStream(is);
        return this.getImageData(bis);
    }

    private InputStream resolveInputStream(HttpServletRequest request, String url) {
        InputStream value = this.getServletContext().getResourceAsStream(url);
        if (value != null) {
            return value;
        }
        for (String path : this.paths) {
            InputStream resource = this.getServletContext().getResourceAsStream(path + url);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    private byte[] getImageData(BufferedInputStream content) {
        try {
            ByteArrayOutputStream outContent = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)content, (OutputStream)outContent);
            content.close();
            return outContent.toByteArray();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Can't copy content.", ex);
        }
    }

    private String getConfig(ServletConfig config, String key) {
        String keyValue = config.getInitParameter(key);
        if (keyValue != null && keyValue.isEmpty()) {
            return null;
        }
        return keyValue;
    }
}

