/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.connector;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import org.restlet.Client;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.engine.connector.Connection;
import org.restlet.engine.connector.ConnectionController;
import org.restlet.engine.connector.ConnectionHelper;
import org.restlet.engine.connector.ConnectionState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClientConnectionHelper
extends ConnectionHelper<Client> {
    protected static final String CONNECTOR_LATCH = "org.restlet.engine.connector.latch";

    public ClientConnectionHelper(Client connector) {
        super(connector, true);
    }

    @Override
    protected Connection<Client> createConnection(SocketChannel socketChannel, ConnectionController controller, InetSocketAddress socketAddress) throws IOException {
        return new Connection<Client>(this, socketChannel, controller, socketAddress, this.getInboundBufferSize(), this.getOutboundBufferSize());
    }

    @Override
    protected ConnectionController createController() {
        return new ConnectionController(this);
    }

    protected SocketChannel createSocketChannel(boolean secure, InetSocketAddress socketAddress) throws UnknownHostException, IOException {
        SocketChannel result = SocketChannel.open();
        result.configureBlocking(false);
        this.configure(result.socket());
        result.connect(socketAddress);
        return result;
    }

    protected SocketChannel createSocketChannel(boolean secure, String hostDomain, int hostPort) throws UnknownHostException, IOException {
        return this.createSocketChannel(secure, new InetSocketAddress(hostDomain, hostPort));
    }

    @Override
    public void doHandleInbound(Response response) {
        if (response != null) {
            this.getLogger().finer("Handling response...");
            boolean handled = false;
            Request request = response.getRequest();
            if (request != null && request.isAsynchronous()) {
                request.getOnResponse().handle(request, response);
                handled = true;
            }
            if (!response.getStatus().isInformational()) {
                this.unblock(response);
            } else if (!handled) {
                this.getLogger().info("Provisional response ignored: " + response);
            }
        }
    }

    @Override
    public void doHandleOutbound(Response response) {
        try {
            if (response != null && response.getRequest() != null) {
                Connection<Client> bestConn;
                if (this.getLogger().isLoggable(Level.FINE)) {
                    this.getLogger().log(Level.FINE, "Client request to be sent: " + response.getRequest());
                }
                if ((bestConn = this.getBestConnection(response.getRequest())) != null) {
                    bestConn.getOutboundWay().handle(response);
                } else {
                    this.getLogger().log(Level.WARNING, "Unable to find a connection to send the request");
                    response.setStatus(Status.CONNECTOR_ERROR_COMMUNICATION, "Unable to find a connection to send the request");
                    this.unblock(response);
                }
            }
        }
        catch (Throwable t) {
            this.getLogger().log(Level.FINE, "An error occured during the communication with the remote server.", t);
            response.setStatus(Status.CONNECTOR_ERROR_COMMUNICATION, t);
            this.unblock(response);
        }
    }

    protected Connection<Client> getBestConnection(Request request) throws UnknownHostException, IOException {
        Connection result = null;
        int hostConnectionCount = 0;
        int bestScore = Integer.MAX_VALUE;
        boolean foundConn = false;
        InetSocketAddress socketAddress = this.getSocketAddress(request);
        if (socketAddress == null) {
            this.getLogger().log(Level.WARNING, "Unable to create a socket address related to the request.");
        } else {
            Iterator iterator = this.getConnections().iterator();
            while (!foundConn && iterator.hasNext()) {
                Connection currConn = iterator.next();
                if (!socketAddress.equals(currConn.getSocketAddress())) continue;
                if (currConn.isAvailable()) {
                    result = currConn;
                    foundConn = true;
                    continue;
                }
                if (currConn.getState().compareTo(ConnectionState.OPEN) > 0) continue;
                int currScore = currConn.getLoadScore();
                if (bestScore > currScore) {
                    bestScore = currScore;
                    result = currConn;
                }
                ++hostConnectionCount;
            }
            if (foundConn) {
                this.getLogger().log(Level.FINE, "Reusing an existing client connection to: " + socketAddress);
            } else if (this.getMaxTotalConnections() != -1 && this.getConnections().size() >= this.getMaxTotalConnections()) {
                if (result == null) {
                    this.getLogger().log(Level.WARNING, "Unable to create a new connection. Maximum total number of connections reached!");
                } else {
                    this.getLogger().log(Level.FINE, "Enqueue Request to an existing client connection to: " + socketAddress);
                }
            } else if (this.getMaxConnectionsPerHost() != -1 && hostConnectionCount >= this.getMaxConnectionsPerHost()) {
                if (result == null) {
                    this.getLogger().log(Level.WARNING, "Unable to create a new connection. Maximum number of connections reached for host: " + socketAddress);
                } else {
                    this.getLogger().log(Level.FINE, "Enqueue Request to an existing client connection to: " + socketAddress);
                }
            } else {
                if (this.getLogger().isLoggable(Level.FINE)) {
                    this.getLogger().log(Level.FINE, "Creating a new client connection to: " + socketAddress);
                }
                result = this.checkout(this.createSocketChannel(request.isConfidential(), socketAddress), this.getController(), socketAddress);
                this.getConnections().add(result);
            }
        }
        return result;
    }

    public String getProxyHost() {
        return this.getHelpedParameters().getFirstValue("proxyHost", System.getProperty("http.proxyHost"));
    }

    public int getProxyPort() {
        String proxyPort = this.getHelpedParameters().getFirstValue("proxyPort", System.getProperty("http.proxyPort"));
        if (proxyPort == null) {
            proxyPort = "3128";
        }
        return Integer.parseInt(proxyPort);
    }

    protected InetSocketAddress getSocketAddress(Request request) throws UnknownHostException {
        InetSocketAddress result = null;
        String hostDomain = null;
        int hostPort = 0;
        String proxyDomain = this.getProxyHost();
        if (proxyDomain != null && !"".equals(proxyDomain)) {
            hostDomain = proxyDomain;
            try {
                hostPort = this.getProxyPort();
            }
            catch (NumberFormatException nfe) {
                this.getLogger().log(Level.WARNING, "The proxy port must be a valid numeric value.", nfe);
                throw new UnknownHostException();
            }
        } else {
            Reference resourceRef = request.getResourceRef().isRelative() ? request.getResourceRef().getTargetRef() : request.getResourceRef();
            hostDomain = resourceRef.getHostDomain();
            hostPort = resourceRef.getHostPort();
            if (hostPort == -1) {
                hostPort = resourceRef.getSchemeProtocol() != null ? resourceRef.getSchemeProtocol().getDefaultPort() : this.getProtocols().get(0).getDefaultPort();
            }
        }
        if (hostDomain != null && (result = new InetSocketAddress(hostDomain, hostPort)) != null && result.getAddress() == null) {
            throw new UnknownHostException(hostDomain);
        }
        return result;
    }

    public int getSocketConnectTimeoutMs() {
        int result = ((Client)this.getHelped()).getConnectTimeout();
        if (this.getHelpedParameters().getNames().contains("socketConnectTimeoutMs")) {
            result = Integer.parseInt(this.getHelpedParameters().getFirstValue("socketConnectTimeoutMs", "0"));
        }
        return result;
    }

    @Override
    public void handle(Request request, Response response) {
        try {
            if (this.getLogger().isLoggable(Level.FINE)) {
                this.getLogger().log(Level.FINE, "Handling client request: " + request);
            }
            if (request != null && request.isSynchronous() && request.isExpectingResponse()) {
                CountDownLatch latch = new CountDownLatch(1);
                request.getAttributes().put(CONNECTOR_LATCH, latch);
                this.addOutboundMessage(response);
                latch.await();
            } else {
                this.addOutboundMessage(response);
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.INFO, "Error while handling a " + request.getProtocol().getName() + " client request", e);
            response.setStatus(Status.CONNECTOR_ERROR_INTERNAL, e);
        }
    }

    @Override
    protected void handleInbound(Response response) {
        this.handleInbound(response, response.getRequest().isSynchronous());
    }

    @Override
    protected void handleOutbound(Response response) {
        this.handleOutbound(response, true);
    }

    @Override
    public boolean isControllerDaemon() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("controllerDaemon", "true"));
    }

    @Override
    public boolean isProxying() {
        return this.getProxyHost() != null;
    }

    @Override
    public void start() throws Exception {
        this.getLogger().info("Starting the internal " + this.getProtocols() + " client");
        super.start();
    }

    @Override
    public void stop() throws Exception {
        this.getLogger().info("Stopping the internal " + this.getProtocols() + " client");
        super.stop();
    }

    protected void unblock(Response response) {
        if (response.getRequest() != null) {
            CountDownLatch latch = (CountDownLatch)response.getRequest().getAttributes().get(CONNECTOR_LATCH);
            if (latch != null) {
                latch.countDown();
            }
        } else {
            this.getLogger().warning("The client of the following response couldn't be unblocked: " + response);
        }
    }
}

