/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.cluster;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Produces;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.cluster.ClusterService;
import org.uberfire.commons.cluster.ClusterServiceFactory;
import org.uberfire.commons.message.MessageHandlerResolver;
import org.uberfire.commons.services.cdi.ApplicationStarted;
import org.uberfire.io.impl.cluster.helix.ClusterServiceHelix;

@ApplicationScoped
public class ClusterServiceFactoryProducer {
    private static final Logger logger = LoggerFactory.getLogger(ClusterServiceFactoryProducer.class);
    private final ClusterServiceFactory factory;
    private ClusterService clusterService = null;

    ClusterServiceFactoryProducer() {
        final String clusterName = System.getProperty("org.uberfire.cluster.id", null);
        final String zkAddress = System.getProperty("org.uberfire.cluster.zk", null);
        final String localId = System.getProperty("org.uberfire.cluster.local.id", null);
        final String resourceName = System.getProperty("org.uberfire.cluster.vfs.lock", null);
        final boolean autostart = Boolean.parseBoolean(System.getProperty("org.uberfire.cluster.autostart", "true"));
        this.factory = clusterName == null || zkAddress == null || localId == null || resourceName == null ? null : new ClusterServiceFactory(){

            public ClusterService build(MessageHandlerResolver resolver) {
                if (ClusterServiceFactoryProducer.this.clusterService == null) {
                    ClusterServiceFactoryProducer.this.clusterService = (ClusterService)new ClusterServiceHelix(clusterName, zkAddress, localId, resourceName, resolver);
                } else {
                    ClusterServiceFactoryProducer.this.clusterService.addMessageHandlerResolver(resolver);
                }
                return ClusterServiceFactoryProducer.this.clusterService;
            }

            public boolean isAutoStart() {
                return autostart;
            }
        };
    }

    @Produces
    @Named(value="clusterServiceFactory")
    public ClusterServiceFactory clusterServiceFactory() {
        return this.factory;
    }

    public void startOnEvent(@Observes ApplicationStarted event) {
        logger.debug("Received event for application started {}", (Object)this.clusterService);
        if (this.clusterService != null) {
            logger.debug("About to create cluster service...");
            this.clusterService.start();
        }
    }
}

