/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.localtime;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.socket.nio.NioServerSocketChannelFactory;
import io.netty.example.localtime.LocalTimeServerPipelineFactory;
import java.net.InetSocketAddress;
import java.util.concurrent.Executors;

public class LocalTimeServer {
    private final int port;

    public LocalTimeServer(int port) {
        this.port = port;
    }

    public void run() {
        ServerBootstrap bootstrap = new ServerBootstrap(new NioServerSocketChannelFactory(Executors.newCachedThreadPool(), Executors.newCachedThreadPool()));
        bootstrap.setPipelineFactory(new LocalTimeServerPipelineFactory());
        bootstrap.bind(new InetSocketAddress(this.port));
    }

    public static void main(String[] args) throws Exception {
        int port = args.length > 0 ? Integer.parseInt(args[0]) : 8080;
        new LocalTimeServer(port).run();
    }
}

